/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.services.elasticbeanstalk.model.OptionRestrictionRegex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationOptionDescription {
    private String namespace;
    private String name;
    private String defaultValue;
    private String changeSeverity;
    private Boolean userDefined;
    private String valueType;
    private List<String> valueOptions;
    private Integer minValue;
    private Integer maxValue;
    private Integer maxLength;
    private OptionRestrictionRegex regex;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ConfigurationOptionDescription withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConfigurationOptionDescription withName(String name) {
        this.name = name;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ConfigurationOptionDescription withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String getChangeSeverity() {
        return this.changeSeverity;
    }

    public void setChangeSeverity(String changeSeverity) {
        this.changeSeverity = changeSeverity;
    }

    public ConfigurationOptionDescription withChangeSeverity(String changeSeverity) {
        this.changeSeverity = changeSeverity;
        return this;
    }

    public Boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(Boolean userDefined) {
        this.userDefined = userDefined;
    }

    public ConfigurationOptionDescription withUserDefined(Boolean userDefined) {
        this.userDefined = userDefined;
        return this;
    }

    public Boolean getUserDefined() {
        return this.userDefined;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public ConfigurationOptionDescription withValueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    public List<String> getValueOptions() {
        if (this.valueOptions == null) {
            this.valueOptions = new ArrayList<String>();
        }
        return this.valueOptions;
    }

    public void setValueOptions(Collection<String> valueOptions) {
        ArrayList<String> valueOptionsCopy = new ArrayList<String>();
        if (valueOptions != null) {
            valueOptionsCopy.addAll(valueOptions);
        }
        this.valueOptions = valueOptionsCopy;
    }

    public ConfigurationOptionDescription withValueOptions(String ... valueOptions) {
        if (this.getValueOptions() == null) {
            this.setValueOptions(new ArrayList<String>());
        }
        for (String value : valueOptions) {
            this.getValueOptions().add(value);
        }
        return this;
    }

    public ConfigurationOptionDescription withValueOptions(Collection<String> valueOptions) {
        ArrayList<String> valueOptionsCopy = new ArrayList<String>();
        if (valueOptions != null) {
            valueOptionsCopy.addAll(valueOptions);
        }
        this.valueOptions = valueOptionsCopy;
        return this;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Integer minValue) {
        this.minValue = minValue;
    }

    public ConfigurationOptionDescription withMinValue(Integer minValue) {
        this.minValue = minValue;
        return this;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public ConfigurationOptionDescription withMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public ConfigurationOptionDescription withMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public OptionRestrictionRegex getRegex() {
        return this.regex;
    }

    public void setRegex(OptionRestrictionRegex regex) {
        this.regex = regex;
    }

    public ConfigurationOptionDescription withRegex(OptionRestrictionRegex regex) {
        this.regex = regex;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("Namespace: " + this.namespace + ", ");
        sb.append("Name: " + this.name + ", ");
        sb.append("DefaultValue: " + this.defaultValue + ", ");
        sb.append("ChangeSeverity: " + this.changeSeverity + ", ");
        sb.append("UserDefined: " + this.userDefined + ", ");
        sb.append("ValueType: " + this.valueType + ", ");
        sb.append("ValueOptions: " + this.valueOptions + ", ");
        sb.append("MinValue: " + this.minValue + ", ");
        sb.append("MaxValue: " + this.maxValue + ", ");
        sb.append("MaxLength: " + this.maxLength + ", ");
        sb.append("Regex: " + this.regex + ", ");
        sb.append("}");
        return sb.toString();
    }
}

