/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.DefaultRequest;
import com.amazonaws.HttpMethod;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.services.s3.internal.Constants;
import com.amazonaws.services.s3.internal.CopyObjectResponseHandler;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.MD5DigestCalculatingInputStream;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.ProgressReportingInputStream;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.RepeatableInputStream;
import com.amazonaws.services.s3.internal.S3ErrorResponseHandler;
import com.amazonaws.services.s3.internal.S3MetadataResponseHandler;
import com.amazonaws.services.s3.internal.S3ObjectResponseHandler;
import com.amazonaws.services.s3.internal.S3QueryStringSigner;
import com.amazonaws.services.s3.internal.S3Signer;
import com.amazonaws.services.s3.internal.S3StringResponseHandler;
import com.amazonaws.services.s3.internal.S3XmlResponseHandler;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketPolicy;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultiFactorAuthentication;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.ProgressEvent;
import com.amazonaws.services.s3.model.ProgressListener;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.model.transform.AclXmlFactory;
import com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactory;
import com.amazonaws.services.s3.model.transform.RequestXmlFactory;
import com.amazonaws.services.s3.model.transform.Unmarshallers;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonS3Client
extends AmazonWebServiceClient
implements AmazonS3 {
    private static Log log = LogFactory.getLog(AmazonS3Client.class);
    private AWSCredentials awsCredentials;
    protected final HttpClient client;
    private final List<RequestHandler> requestHandlers;
    private S3ErrorResponseHandler errorResponseHandler = new S3ErrorResponseHandler();
    private S3XmlResponseHandler<Void> voidResponseHandler = new S3XmlResponseHandler(null);
    private final BucketNameUtils bucketNameUtils = new BucketNameUtils();
    private static final BucketConfigurationXmlFactory bucketConfigurationXmlFactory = new BucketConfigurationXmlFactory();

    public AmazonS3Client() {
        this((AWSCredentials)null);
    }

    public AmazonS3Client(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonS3Client(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.setEndpoint(Constants.S3_HOSTNAME);
        this.client = new HttpClient(clientConfiguration);
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers = Collections.synchronizedList(chainFactory.newRequestHandlerChain("/com/amazonaws/services/s3/request.handlers"));
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    @Override
    public VersionListing listNextBatchOfVersions(VersionListing previousVersionListing) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(previousVersionListing, "The previous version listing parameter must be specified when listing the next batch of versions in a bucket");
        if (!previousVersionListing.isTruncated()) {
            VersionListing emptyListing = new VersionListing();
            emptyListing.setBucketName(previousVersionListing.getBucketName());
            emptyListing.setDelimiter(previousVersionListing.getDelimiter());
            emptyListing.setKeyMarker(previousVersionListing.getNextKeyMarker());
            emptyListing.setVersionIdMarker(previousVersionListing.getNextVersionIdMarker());
            emptyListing.setMaxKeys(previousVersionListing.getMaxKeys());
            emptyListing.setPrefix(previousVersionListing.getPrefix());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listVersions(new ListVersionsRequest(previousVersionListing.getBucketName(), previousVersionListing.getPrefix(), previousVersionListing.getNextKeyMarker(), previousVersionListing.getNextVersionIdMarker(), previousVersionListing.getDelimiter(), new Integer(previousVersionListing.getMaxKeys())));
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix) throws AmazonClientException, AmazonServiceException {
        return this.listVersions(new ListVersionsRequest(bucketName, prefix, null, null, null, null));
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxKeys) throws AmazonClientException, AmazonServiceException {
        ListVersionsRequest request = new ListVersionsRequest().withBucketName(bucketName).withPrefix(prefix).withDelimiter(delimiter).withKeyMarker(keyMarker).withVersionIdMarker(versionIdMarker).withMaxResults(maxKeys);
        return this.listVersions(request);
    }

    @Override
    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws AmazonClientException, AmazonServiceException {
        String bucketName = listVersionsRequest.getBucketName();
        String prefix = listVersionsRequest.getPrefix();
        String keyMarker = listVersionsRequest.getKeyMarker();
        String versionIdMarker = listVersionsRequest.getVersionIdMarker();
        String delimiter = listVersionsRequest.getDelimiter();
        Integer maxResults = listVersionsRequest.getMaxResults();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when listing versions in a bucket");
        Request<Void> request = this.createRequest(bucketName, null, listVersionsRequest, HttpMethodName.GET);
        request.addParameter("versions", null);
        if (prefix != null) {
            request.addParameter("prefix", prefix);
        }
        if (keyMarker != null) {
            request.addParameter("key-marker", keyMarker);
        }
        if (versionIdMarker != null) {
            request.addParameter("version-id-marker", versionIdMarker);
        }
        if (delimiter != null) {
            request.addParameter("delimiter", delimiter);
        }
        if (maxResults != null && maxResults >= 0) {
            request.addParameter("max-keys", maxResults.toString());
        }
        this.signRequest(request, bucketName, null);
        S3XmlResponseHandler<VersionListing> responseHandler = new S3XmlResponseHandler<VersionListing>(new Unmarshallers.VersionListUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (VersionListing)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String bucketName, String prefix) throws AmazonClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, prefix, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws AmazonClientException, AmazonServiceException {
        String bucketName = listObjectsRequest.getBucketName();
        String prefix = listObjectsRequest.getPrefix();
        String marker = listObjectsRequest.getMarker();
        String delimiter = listObjectsRequest.getDelimiter();
        Integer maxKeys = listObjectsRequest.getMaxKeys();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when listing objects in a bucket");
        Request<Void> request = this.createRequest(bucketName, null, listObjectsRequest, HttpMethodName.GET);
        if (prefix != null) {
            request.addParameter("prefix", prefix);
        }
        if (marker != null) {
            request.addParameter("marker", marker);
        }
        if (delimiter != null) {
            request.addParameter("delimiter", delimiter);
        }
        if (maxKeys != null && maxKeys > 0) {
            request.addParameter("max-keys", maxKeys.toString());
        }
        this.signRequest(request, bucketName, null);
        S3XmlResponseHandler<ObjectListing> responseHandler = new S3XmlResponseHandler<ObjectListing>(new Unmarshallers.ListObjectsUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (ObjectListing)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ObjectListing previousObjectListing) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(previousObjectListing, "The previous object listing parameter must be specified when listing the next batch of objects in a bucket");
        if (!previousObjectListing.isTruncated()) {
            ObjectListing emptyListing = new ObjectListing();
            emptyListing.setBucketName(previousObjectListing.getBucketName());
            emptyListing.setDelimiter(previousObjectListing.getDelimiter());
            emptyListing.setMarker(previousObjectListing.getNextMarker());
            emptyListing.setMaxKeys(previousObjectListing.getMaxKeys());
            emptyListing.setPrefix(previousObjectListing.getPrefix());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listObjects(new ListObjectsRequest(previousObjectListing.getBucketName(), previousObjectListing.getPrefix(), previousObjectListing.getNextMarker(), previousObjectListing.getDelimiter(), new Integer(previousObjectListing.getMaxKeys())));
    }

    @Override
    public Owner getS3AccountOwner() throws AmazonClientException, AmazonServiceException {
        Request<Void> request = this.createRequest(null, null, null, HttpMethodName.GET);
        this.signRequest(request, null, null);
        S3XmlResponseHandler<Owner> responseHandler = new S3XmlResponseHandler<Owner>(new Unmarshallers.ListBucketsOwnerUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (Owner)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws AmazonClientException, AmazonServiceException {
        Request<Void> request = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        this.signRequest(request, null, null);
        S3XmlResponseHandler<List<Bucket>> responseHandler = new S3XmlResponseHandler<List<Bucket>>(new Unmarshallers.ListBucketsUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (List)((Object)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext));
    }

    @Override
    public List<Bucket> listBuckets() throws AmazonClientException, AmazonServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public String getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(getBucketLocationRequest, "The request parameter must be specified when requesting a bucket's location");
        String bucketName = getBucketLocationRequest.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's location");
        Request<Void> request = this.createRequest(bucketName, null, getBucketLocationRequest, HttpMethodName.GET);
        request.addParameter("location", null);
        this.signRequest(request, bucketName, null);
        S3XmlResponseHandler<String> responseHandler = new S3XmlResponseHandler<String>(new Unmarshallers.BucketLocationUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (String)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public String getBucketLocation(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.getBucketLocation(new GetBucketLocationRequest(bucketName));
    }

    @Override
    public Bucket createBucket(String bucketName) throws AmazonClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    @Override
    public Bucket createBucket(String bucketName, Region region) throws AmazonClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName, region));
    }

    @Override
    public Bucket createBucket(String bucketName, String region) throws AmazonClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName, region));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String bucketName = createBucketRequest.getBucketName();
        String region = createBucketRequest.getRegion();
        CannedAccessControlList acl = createBucketRequest.getCannedAcl();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when creating a bucket");
        if (bucketName != null) {
            bucketName = bucketName.trim();
        }
        this.bucketNameUtils.validateBucketName(bucketName);
        Request<Void> request = this.createRequest(bucketName, null, createBucketRequest, HttpMethodName.PUT);
        if (acl != null) {
            request.addHeader("x-amz-acl", acl.toString());
        }
        this.signRequest(request, bucketName, null);
        if (region != null && !region.toUpperCase().equals(Region.US_Standard.toString())) {
            XmlWriter xml = new XmlWriter();
            xml.start("CreateBucketConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
            xml.start("LocationConstraint").value(region).end();
            xml.end();
            request.setContent(new ByteArrayInputStream(xml.getBytes()));
        }
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
        return new Bucket(bucketName);
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        return this.getObjectAcl(bucketName, key, null);
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key, String versionId) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting an object's ACL");
        this.assertParameterNotNull(key, "The key parameter must be specified when requesting an object's ACL");
        return this.getAcl(bucketName, key, versionId);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, AccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl(bucketName, key, null, acl);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, CannedAccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.setObjectAcl(bucketName, key, null, acl);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, String versionId, AccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull(key, "The key parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull(acl, "The ACL parameter must be specified when setting an object's ACL");
        this.setAcl(bucketName, key, versionId, acl);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, String versionId, CannedAccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull(key, "The key parameter must be specified when setting an object's ACL");
        this.assertParameterNotNull((Object)acl, "The ACL parameter must be specified when setting an object's ACL");
        this.setAcl(bucketName, key, versionId, acl);
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(bucketName, null, null);
    }

    @Override
    public void setBucketAcl(String bucketName, AccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting a bucket's ACL");
        this.assertParameterNotNull(acl, "The ACL parameter must be specified when setting a bucket's ACL");
        this.setAcl(bucketName, null, null, acl);
    }

    @Override
    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting a bucket's ACL");
        this.assertParameterNotNull((Object)acl, "The ACL parameter must be specified when setting a bucket's ACL");
        this.setAcl(bucketName, null, null, acl);
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(getObjectMetadataRequest, "The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        String bucketName = getObjectMetadataRequest.getBucketName();
        String key = getObjectMetadataRequest.getKey();
        String versionId = getObjectMetadataRequest.getVersionId();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting an object's metadata");
        this.assertParameterNotNull(key, "The key parameter must be specified when requesting an object's metadata");
        Request<Void> request = this.createRequest(bucketName, key, getObjectMetadataRequest, HttpMethodName.HEAD);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        this.signRequest(request, bucketName, key);
        S3MetadataResponseHandler responseHandler = new S3MetadataResponseHandler();
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public S3Object getObject(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws AmazonClientException, AmazonServiceException {
        try {
            this.listObjects(new ListObjectsRequest(bucketName, null, null, null, 0));
            return true;
        }
        catch (AmazonServiceException ase) {
            switch (ase.getStatusCode()) {
                case 403: {
                    return true;
                }
                case 404: {
                    return false;
                }
            }
            throw ase;
        }
    }

    @Override
    public void changeObjectStorageClass(String bucketName, String key, StorageClass newStorageClass) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucketName parameter must be specified when changing an object's storage class");
        this.assertParameterNotNull(key, "The key parameter must be specified when changing an object's storage class");
        this.assertParameterNotNull((Object)newStorageClass, "The newStorageClass parameter must be specified when changing an object's storage class");
        this.copyObject(new CopyObjectRequest(bucketName, key, bucketName, key).withStorageClass(newStorageClass.toString()));
    }

    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(getObjectRequest, "The GetObjectRequest parameter must be specified when requesting an object");
        this.assertParameterNotNull(getObjectRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object");
        this.assertParameterNotNull(getObjectRequest.getKey(), "The key parameter must be specified when requesting an object");
        String bucketName = getObjectRequest.getBucketName();
        String key = getObjectRequest.getKey();
        Request<Void> request = this.createRequest(bucketName, key, getObjectRequest, HttpMethodName.GET);
        if (getObjectRequest.getVersionId() != null) {
            request.addParameter("versionId", getObjectRequest.getVersionId());
        }
        if (getObjectRequest.getRange() != null) {
            long[] range = getObjectRequest.getRange();
            request.addHeader("Range", "bytes=" + Long.toString(range[0]) + "-" + Long.toString(range[1]));
        }
        AmazonS3Client.addResponseHeaderParameters(request, getObjectRequest.getResponseHeaders());
        AmazonS3Client.addDateHeader(request, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "If-Unmodified-Since", getObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "If-Match", getObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "If-None-Match", getObjectRequest.getNonmatchingETagConstraints());
        this.signRequest(request, bucketName, key);
        try {
            S3ObjectResponseHandler responseHandler = new S3ObjectResponseHandler();
            ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
            S3Object s3Object = this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
            s3Object.setBucketName(bucketName);
            s3Object.setKey(key);
            return s3Object;
        }
        catch (AmazonS3Exception ase) {
            if (ase.getStatusCode() == 412 || ase.getStatusCode() == 304) {
                return null;
            }
            throw ase;
        }
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File destinationFile) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = this.getObject(getObjectRequest);
        if (s3Object == null) {
            return null;
        }
        OutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[10240];
            while ((bytesRead = s3Object.getObjectContent().read(buffer)) > -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to store object contents to disk: " + e.getMessage(), e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception e) {}
            try {
                s3Object.getObjectContent().close();
            }
            catch (Exception e) {}
        }
        try {
            byte[] clientSideHash = ServiceUtils.computeMD5Hash(new FileInputStream(destinationFile));
            byte[] serverSideHash = ServiceUtils.fromHex(s3Object.getObjectMetadata().getETag());
            if (!Arrays.equals(clientSideHash, serverSideHash)) {
                throw new AmazonClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Amazon S3.  The data stored in '" + destinationFile.getAbsolutePath() + "' may be corrupt.");
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to calculate MD5 hash to validate download: " + e.getMessage()), (Throwable)e);
        }
        return s3Object.getObjectMetadata();
    }

    @Override
    public void deleteBucket(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.deleteBucket(new DeleteBucketRequest(bucketName));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(deleteBucketRequest, "The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String bucketName = deleteBucketRequest.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when deleting a bucket");
        Request<Void> request = this.createRequest(bucketName, null, deleteBucketRequest, HttpMethodName.DELETE);
        this.signRequest(request, bucketName, null);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, File file) throws AmazonClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws AmazonClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        byte[] serverSideHash;
        byte[] clientSideHash;
        this.assertParameterNotNull(putObjectRequest, "The PutObjectRequest parameter must be specified when uploading an object");
        String bucketName = putObjectRequest.getBucketName();
        String key = putObjectRequest.getKey();
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        InputStream input = putObjectRequest.getInputStream();
        ProgressListener progressListener = putObjectRequest.getProgressListener();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when uploading an object");
        this.assertParameterNotNull(key, "The key parameter must be specified when uploading an object");
        if (putObjectRequest.getFile() != null) {
            File file = putObjectRequest.getFile();
            metadata.setContentLength(file.length());
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                byte[] md5Hash = ServiceUtils.computeMD5Hash(fileInputStream);
                metadata.setContentMD5(ServiceUtils.toBase64(md5Hash));
            }
            catch (Exception e) {
                throw new AmazonClientException("Unable to calculate MD5 hash: " + e.getMessage(), e);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {}
            }
            try {
                input = new RepeatableFileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new AmazonClientException("Unable to find file to upload", fnfe);
            }
        }
        Request<Void> request = this.createRequest(bucketName, key, putObjectRequest, HttpMethodName.PUT);
        if (putObjectRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", putObjectRequest.getCannedAcl().toString());
        }
        if (putObjectRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", putObjectRequest.getStorageClass());
        }
        if (metadata.getContentLength() <= 0L) {
            log.warn((Object)"No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
        }
        if (progressListener != null) {
            input = new ProgressReportingInputStream(input, progressListener);
            this.fireProgressEvent(progressListener, 1);
        }
        if (!input.markSupported()) {
            input = new RepeatableInputStream(input, 131072);
        }
        MD5DigestCalculatingInputStream md5DigestStream = null;
        if (metadata.getContentMD5() == null) {
            try {
                md5DigestStream = new MD5DigestCalculatingInputStream(input);
                input = md5DigestStream;
            }
            catch (NoSuchAlgorithmException e) {
                log.warn((Object)"No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)e);
            }
        }
        if (metadata.getContentType() == null) {
            metadata.setContentType("application/octet-stream");
        }
        AmazonS3Client.populateRequestMetadata(request, metadata);
        this.signRequest(request, bucketName, key);
        request.setContent(input);
        ObjectMetadata returnedMetadata = null;
        try {
            S3MetadataResponseHandler responseHandler = new S3MetadataResponseHandler();
            ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
            returnedMetadata = this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
        }
        catch (AmazonClientException ace) {
            this.fireProgressEvent(progressListener, 4);
            throw ace;
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {
                log.warn((Object)("Unable to cleanly close input stream: " + e.getMessage()), (Throwable)e);
            }
        }
        String contentMd5 = metadata.getContentMD5();
        if (md5DigestStream != null) {
            contentMd5 = ServiceUtils.toBase64(md5DigestStream.getMd5Digest());
        }
        if (returnedMetadata != null && contentMd5 != null && !Arrays.equals(clientSideHash = ServiceUtils.fromBase64(contentMd5), serverSideHash = ServiceUtils.fromHex(returnedMetadata.getETag()))) {
            this.fireProgressEvent(progressListener, 4);
            throw new AmazonClientException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by Amazon S3.  You may need to delete the data stored in Amazon S3.");
        }
        this.fireProgressEvent(progressListener, 2);
        PutObjectResult result = new PutObjectResult();
        result.setETag(returnedMetadata.getETag());
        result.setVersionId(returnedMetadata.getVersionId());
        return result;
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws AmazonClientException, AmazonServiceException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
        String destinationKey = copyObjectRequest.getDestinationKey();
        String destinationBucketName = copyObjectRequest.getDestinationBucketName();
        Request<Void> request = this.createRequest(destinationBucketName, destinationKey, copyObjectRequest, HttpMethodName.PUT);
        AmazonS3Client.populateRequestWithCopyObjectParameters(request, copyObjectRequest);
        request.getHeaders().remove("Content-Length");
        this.signRequest(request, destinationBucketName, destinationKey);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
            CopyObjectResponseHandler responseHandler = new CopyObjectResponseHandler();
            copyObjectResultHandler = this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
        }
        catch (AmazonS3Exception ase) {
            if (ase.getStatusCode() == 412) {
                return null;
            }
            throw ase;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            String errorCode = copyObjectResultHandler.getErrorCode();
            String errorMessage = copyObjectResultHandler.getErrorMessage();
            String requestId = copyObjectResultHandler.getErrorRequestId();
            String hostId = copyObjectResultHandler.getErrorHostId();
            AmazonS3Exception ase = new AmazonS3Exception(errorMessage);
            ase.setErrorCode(errorCode);
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(hostId);
            ase.setServiceName(request.getServiceName());
            ase.setStatusCode(200);
            throw ase;
        }
        CopyObjectResult copyObjectResult = new CopyObjectResult();
        copyObjectResult.setETag(copyObjectResultHandler.getETag());
        copyObjectResult.setLastModifiedDate(copyObjectResultHandler.getLastModified());
        copyObjectResult.setVersionId(copyObjectResultHandler.getVersionId());
        return copyObjectResult;
    }

    @Override
    public void deleteObject(String bucketName, String key) throws AmazonClientException, AmazonServiceException {
        this.deleteObject(new DeleteObjectRequest(bucketName, key));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(deleteObjectRequest, "The delete object request must be specified when deleting an object");
        String bucketName = deleteObjectRequest.getBucketName();
        String key = deleteObjectRequest.getKey();
        this.assertParameterNotNull(bucketName, "The bucket name must be specified when deleting an object");
        this.assertParameterNotNull(key, "The key must be specified when deleting an object");
        Request<Void> request = this.createRequest(bucketName, key, deleteObjectRequest, HttpMethodName.DELETE);
        this.signRequest(request, bucketName, key);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public void deleteVersion(String bucketName, String key, String versionId) throws AmazonClientException, AmazonServiceException {
        this.deleteVersion(new DeleteVersionRequest(bucketName, key, versionId));
    }

    @Override
    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(deleteVersionRequest, "The delete version request object must be specified when deleting a version");
        String bucketName = deleteVersionRequest.getBucketName();
        String key = deleteVersionRequest.getKey();
        String versionId = deleteVersionRequest.getVersionId();
        this.assertParameterNotNull(bucketName, "The bucket name must be specified when deleting a version");
        this.assertParameterNotNull(key, "The key must be specified when deleting a version");
        this.assertParameterNotNull(versionId, "The version ID must be specified when deleting a version");
        Request<Void> request = this.createRequest(bucketName, key, deleteVersionRequest, HttpMethodName.DELETE);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        if (deleteVersionRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, deleteVersionRequest.getMfa());
        }
        this.signRequest(request, bucketName, key);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(setBucketVersioningConfigurationRequest, "The SetBucketVersioningConfigurationRequest object must be specified when setting versioning configuration");
        String bucketName = setBucketVersioningConfigurationRequest.getBucketName();
        BucketVersioningConfiguration versioningConfiguration = setBucketVersioningConfigurationRequest.getVersioningConfiguration();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting versioning configuration");
        this.assertParameterNotNull(versioningConfiguration, "The bucket versioning parameter must be specified when setting versioning configuration");
        if (versioningConfiguration.isMfaDeleteEnabled() != null) {
            this.assertParameterNotNull(setBucketVersioningConfigurationRequest.getMfa(), "The MFA parameter must be specified when changing MFA Delete status in the versioning configuration");
        }
        Request<Void> request = this.createRequest(bucketName, null, setBucketVersioningConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("versioning", null);
        if (versioningConfiguration.isMfaDeleteEnabled() != null && setBucketVersioningConfigurationRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, setBucketVersioningConfigurationRequest.getMfa());
        }
        this.signRequest(request, bucketName, null);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(versioningConfiguration);
        request.setContent(new ByteArrayInputStream(bytes));
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when querying versioning configuration");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.GET);
        request.addParameter("versioning", null);
        this.signRequest(request, bucketName, null);
        S3XmlResponseHandler<BucketVersioningConfiguration> responseHandler = new S3XmlResponseHandler<BucketVersioningConfiguration>(new Unmarshallers.BucketVersioningConfigurationUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (BucketVersioningConfiguration)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's website configuration");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.GET);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        this.signRequest(request, bucketName, null);
        S3XmlResponseHandler<BucketWebsiteConfiguration> responseHandler = new S3XmlResponseHandler<BucketWebsiteConfiguration>(new Unmarshallers.BucketWebsiteConfigurationUnmarshaller());
        try {
            ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
            return (BucketWebsiteConfiguration)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() == 404) {
                return null;
            }
            throw ase;
        }
    }

    @Override
    public void setBucketWebsiteConfiguration(String bucketName, BucketWebsiteConfiguration configuration) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting a bucket's website configuration");
        this.assertParameterNotNull(configuration, "The bucket website configuration parameter must be specified when setting a bucket's website configuration");
        this.assertParameterNotNull(configuration.getIndexDocumentSuffix(), "The bucket website configuration parameter must specify the index document suffix when setting a bucket's website configuration");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.PUT);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        this.signRequest(request, bucketName, null);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(configuration);
        request.setContent(new ByteArrayInputStream(bytes));
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public void deleteBucketWebsiteConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when deleting a bucket's website configuration");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.DELETE);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        this.signRequest(request, bucketName, null);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public void setBucketNotificationConfiguration(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting notification configuration");
        this.assertParameterNotNull(bucketNotificationConfiguration, "The bucket notification parameter must be specified when setting notification configuration");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.PUT);
        request.addParameter("notification", null);
        this.signRequest(request, bucketName, null);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketNotificationConfiguration);
        request.setContent(new ByteArrayInputStream(bytes));
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public BucketNotificationConfiguration getBucketNotificationConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when querying notification configuration");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.GET);
        request.addParameter("notification", null);
        this.signRequest(request, bucketName, null);
        S3XmlResponseHandler<BucketNotificationConfiguration> responseHandler = new S3XmlResponseHandler<BucketNotificationConfiguration>(new Unmarshallers.BucketNotificationConfigurationUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (BucketNotificationConfiguration)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's logging status");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.GET);
        request.addParameter("logging", null);
        this.signRequest(request, bucketName, null);
        S3XmlResponseHandler<BucketLoggingConfiguration> responseHandler = new S3XmlResponseHandler<BucketLoggingConfiguration>(new Unmarshallers.BucketLoggingConfigurationnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (BucketLoggingConfiguration)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public void setBucketLoggingConfiguration(SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(setBucketLoggingConfigurationRequest, "The set bucket logging configuration request object must be specified when enabling server access logging");
        String bucketName = setBucketLoggingConfigurationRequest.getBucketName();
        BucketLoggingConfiguration loggingConfiguration = setBucketLoggingConfigurationRequest.getLoggingConfiguration();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when enabling server access logging");
        this.assertParameterNotNull(bucketName, "The logging configuration parameter must be specified when enabling server access logging");
        Request<Void> request = this.createRequest(bucketName, null, setBucketLoggingConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("logging", null);
        this.signRequest(request, bucketName, null);
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(loggingConfiguration);
        request.setContent(new ByteArrayInputStream(bytes));
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public BucketPolicy getBucketPolicy(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name must be specified when getting a bucket policy");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.GET);
        request.addParameter("policy", null);
        this.signRequest(request, bucketName, null);
        BucketPolicy result = new BucketPolicy();
        try {
            ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
            String policyText = this.client.execute(request, new S3StringResponseHandler(), this.errorResponseHandler, executionContext);
            result.setPolicyText(policyText);
            return result;
        }
        catch (AmazonServiceException ase) {
            if (ase.getErrorCode().equals("NoSuchBucketPolicy")) {
                return result;
            }
            throw ase;
        }
    }

    @Override
    public void setBucketPolicy(String bucketName, String policyText) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name must be specified when setting a bucket policy");
        this.assertParameterNotNull(policyText, "The policy text must be specified when setting a bucket policy");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.PUT);
        request.addParameter("policy", null);
        this.signRequest(request, bucketName, null);
        request.setContent(new ByteArrayInputStream(ServiceUtils.toByteArray(policyText)));
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public void deleteBucketPolicy(String bucketName) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name must be specified when deleting a bucket policy");
        Request<Void> request = this.createRequest(bucketName, null, null, HttpMethodName.DELETE);
        request.addParameter("policy", null);
        this.signRequest(request, bucketName, null);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws AmazonClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, HttpMethod.GET);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethod method) throws AmazonClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, method);
        request.setExpiration(expiration);
        return this.generatePresignedUrl(request);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) throws AmazonClientException {
        this.assertParameterNotNull(generatePresignedUrlRequest, "The request parameter must be specified when generating a pre-signed URL");
        String bucketName = generatePresignedUrlRequest.getBucketName();
        String key = generatePresignedUrlRequest.getKey();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when generating a pre-signed URL");
        this.assertParameterNotNull((Object)generatePresignedUrlRequest.getMethod(), "The HTTP method request parameter must be specified when generating a pre-signed URL");
        if (generatePresignedUrlRequest.getExpiration() == null) {
            generatePresignedUrlRequest.setExpiration(new Date(System.currentTimeMillis() + 900000L));
        }
        HttpMethodName httpMethod = HttpMethodName.valueOf(generatePresignedUrlRequest.getMethod().toString());
        Request<Void> request = this.createRequest(bucketName, key, generatePresignedUrlRequest, httpMethod);
        for (Map.Entry<String, String> entry : generatePresignedUrlRequest.getRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AmazonS3Client.addResponseHeaderParameters(request, generatePresignedUrlRequest.getResponseHeaders());
        this.presignRequest(request, generatePresignedUrlRequest.getMethod(), bucketName, key, generatePresignedUrlRequest.getExpiration(), null);
        return ServiceUtils.convertRequestToUrl(request);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(abortMultipartUploadRequest, "The request parameter must be specified when aborting a multipart upload");
        this.assertParameterNotNull(abortMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when aborting a multipart upload");
        this.assertParameterNotNull(abortMultipartUploadRequest.getKey(), "The key parameter must be specified when aborting a multipart upload");
        this.assertParameterNotNull(abortMultipartUploadRequest.getUploadId(), "The upload ID parameter must be specified when aborting a multipart upload");
        String bucketName = abortMultipartUploadRequest.getBucketName();
        String key = abortMultipartUploadRequest.getKey();
        Request<Void> request = this.createRequest(bucketName, key, abortMultipartUploadRequest, HttpMethodName.DELETE);
        request.addParameter("uploadId", abortMultipartUploadRequest.getUploadId());
        this.signRequest(request, bucketName, key);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(completeMultipartUploadRequest, "The request parameter must be specified when completing a multipart upload");
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String key = completeMultipartUploadRequest.getKey();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(key, "The key parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(uploadId, "The upload ID parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(completeMultipartUploadRequest.getPartETags(), "The part ETags parameter must be specified when completing a multipart upload");
        Request<Void> request = this.createRequest(bucketName, key, completeMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploadId", uploadId);
        byte[] xml = RequestXmlFactory.convertToXmlByteArray(completeMultipartUploadRequest.getPartETags());
        request.addHeader("Content-Type", "text/plain");
        request.addHeader("Content-Length", String.valueOf(xml.length));
        this.signRequest(request, bucketName, key);
        request.setContent(new ByteArrayInputStream(xml));
        S3XmlResponseHandler<XmlResponsesSaxParser.CompleteMultipartUploadHandler> responseHandler = new S3XmlResponseHandler<XmlResponsesSaxParser.CompleteMultipartUploadHandler>(new Unmarshallers.CompleteMultipartUploadResultUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        XmlResponsesSaxParser.CompleteMultipartUploadHandler handler = (XmlResponsesSaxParser.CompleteMultipartUploadHandler)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
        if (handler.getCompleteMultipartUploadResult() != null) {
            String versionId = responseHandler.getResponseHeaders().get("x-amz-version-id");
            handler.getCompleteMultipartUploadResult().setVersionId(versionId);
            return handler.getCompleteMultipartUploadResult();
        }
        throw handler.getAmazonS3Exception();
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(initiateMultipartUploadRequest, "The request parameter must be specified when initiating a multipart upload");
        String bucketName = initiateMultipartUploadRequest.getBucketName();
        String key = initiateMultipartUploadRequest.getKey();
        CannedAccessControlList cannedACL = initiateMultipartUploadRequest.getCannedACL();
        StorageClass storageClass = initiateMultipartUploadRequest.getStorageClass();
        ObjectMetadata objectMetadata = initiateMultipartUploadRequest.objectMetadata;
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when initiating a multipart upload");
        this.assertParameterNotNull(key, "The key parameter must be specified when initiating a multipart upload");
        Request<Void> request = this.createRequest(bucketName, key, initiateMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploads", null);
        if (storageClass != null) {
            request.addHeader("x-amz-storage-class", storageClass.toString());
        }
        if (cannedACL != null) {
            request.addHeader("x-amz-acl", cannedACL.toString());
        }
        if (objectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, objectMetadata);
        }
        request.getHeaders().remove("Content-Length");
        this.signRequest(request, bucketName, key);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        S3XmlResponseHandler<InitiateMultipartUploadResult> responseHandler = new S3XmlResponseHandler<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (InitiateMultipartUploadResult)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(listMultipartUploadsRequest, "The request parameter must be specified when listing multipart uploads");
        String bucketName = listMultipartUploadsRequest.getBucketName();
        String keyMarker = listMultipartUploadsRequest.getKeyMarker();
        Integer maxUploads = listMultipartUploadsRequest.getMaxUploads();
        String uploadIdMarker = listMultipartUploadsRequest.getUploadIdMarker();
        String delimiter = listMultipartUploadsRequest.getDelimiter();
        String prefix = listMultipartUploadsRequest.getPrefix();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when listing multipart uploads");
        Request<Void> request = this.createRequest(bucketName, null, listMultipartUploadsRequest, HttpMethodName.GET);
        request.addParameter("uploads", null);
        if (keyMarker != null) {
            request.addParameter("key-marker", keyMarker);
        }
        if (maxUploads != null) {
            request.addParameter("max-uploads", maxUploads.toString());
        }
        if (uploadIdMarker != null) {
            request.addParameter("upload-id-marker", uploadIdMarker);
        }
        if (delimiter != null) {
            request.addParameter("delimiter", delimiter);
        }
        if (prefix != null) {
            request.addParameter("prefix", prefix);
        }
        this.signRequest(request, bucketName, null);
        S3XmlResponseHandler<MultipartUploadListing> responseHandler = new S3XmlResponseHandler<MultipartUploadListing>(new Unmarshallers.ListMultipartUploadsResultUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (MultipartUploadListing)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(listPartsRequest, "The request parameter must be specified when listing parts");
        String bucketName = listPartsRequest.getBucketName();
        String key = listPartsRequest.getKey();
        String uploadId = listPartsRequest.getUploadId();
        Integer maxParts = listPartsRequest.getMaxParts();
        Integer partNumberMarker = listPartsRequest.getPartNumberMarker();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when listing parts");
        this.assertParameterNotNull(key, "The key parameter must be specified when listing parts");
        this.assertParameterNotNull(uploadId, "The upload ID parameter must be specified when listing parts");
        Request<Void> request = this.createRequest(bucketName, key, listPartsRequest, HttpMethodName.GET);
        request.addParameter("uploadId", uploadId);
        if (maxParts != null) {
            request.addParameter("max-parts", maxParts.toString());
        }
        if (partNumberMarker != null) {
            request.addParameter("part-number-marker", partNumberMarker.toString());
        }
        this.signRequest(request, bucketName, key);
        S3XmlResponseHandler<PartListing> responseHandler = new S3XmlResponseHandler<PartListing>(new Unmarshallers.ListPartsResultUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (PartListing)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(uploadPartRequest, "The request parameter must be specified when uploading a part");
        String bucketName = uploadPartRequest.getBucketName();
        String key = uploadPartRequest.getKey();
        String uploadId = uploadPartRequest.getUploadId();
        int partNumber = uploadPartRequest.getPartNumber();
        long partSize = uploadPartRequest.getPartSize();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when uploading a part");
        this.assertParameterNotNull(key, "The key parameter must be specified when uploading a part");
        this.assertParameterNotNull(uploadId, "The upload ID parameter must be specified when uploading a part");
        this.assertParameterNotNull(partNumber, "The part number parameter must be specified when uploading a part");
        this.assertParameterNotNull(partSize, "The part size parameter must be specified when uploading a part");
        Request<Void> request = this.createRequest(bucketName, key, uploadPartRequest, HttpMethodName.PUT);
        request.addParameter("uploadId", uploadId);
        request.addParameter("partNumber", Integer.toString(partNumber));
        if (uploadPartRequest.getMd5Digest() != null) {
            request.addHeader("Content-MD5", uploadPartRequest.getMd5Digest());
        }
        this.signRequest(request, bucketName, key);
        request.addHeader("Content-Length", Long.toString(partSize));
        InputStream inputStream = null;
        if (uploadPartRequest.getInputStream() != null) {
            inputStream = uploadPartRequest.getInputStream();
        } else if (uploadPartRequest.getFile() != null) {
            try {
                inputStream = new InputSubstream(new RepeatableFileInputStream(uploadPartRequest.getFile()), uploadPartRequest.getFileOffset(), partSize);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The specified file doesn't exist", e);
            }
        } else {
            throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
        }
        ProgressListener progressListener = uploadPartRequest.getProgressListener();
        if (progressListener != null) {
            inputStream = new ProgressReportingInputStream(inputStream, progressListener);
            this.fireProgressEvent(progressListener, 1024);
        }
        try {
            request.setContent(inputStream);
            ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
            S3MetadataResponseHandler responseHandler = new S3MetadataResponseHandler();
            ObjectMetadata metadata = this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
            this.fireProgressEvent(progressListener, 2048);
            UploadPartResult result = new UploadPartResult();
            result.setETag(metadata.getETag());
            result.setPartNumber(partNumber);
            UploadPartResult uploadPartResult = result;
            return uploadPartResult;
        }
        catch (AmazonClientException ace) {
            this.fireProgressEvent(progressListener, 4096);
            throw ace;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public S3ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return (S3ResponseMetadata)this.client.getResponseMetadataForRequest(request);
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void fireProgressEvent(ProgressListener listener, int eventType) {
        if (listener == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0);
        event.setEventCode(eventType);
        listener.progressChanged(event);
    }

    private AccessControlList getAcl(String bucketName, String key, String versionId) {
        Request<Void> request = this.createRequest(bucketName, key, null, HttpMethodName.GET);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        this.signRequest(request, bucketName, key);
        S3XmlResponseHandler<AccessControlList> responseHandler = new S3XmlResponseHandler<AccessControlList>(new Unmarshallers.AccessControlListUnmarshaller());
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (AccessControlList)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    protected Request<Void> createRequest(String bucketName, String key, AmazonWebServiceRequest originalRequest, HttpMethodName httpMethod) {
        DefaultRequest<Void> request = new DefaultRequest<Void>(originalRequest, Constants.S3_SERVICE_NAME);
        request.setHttpMethod(httpMethod);
        if (this.bucketNameUtils.isValidV2BucketName(bucketName)) {
            request.setEndpoint(this.convertToVirtualHostEndpoint(bucketName));
            request.setResourcePath(ServiceUtils.urlEncode(key));
        } else {
            request.setEndpoint(this.endpoint);
            if (bucketName != null) {
                request.setResourcePath(bucketName + "/" + (key != null ? ServiceUtils.urlEncode(key) : ""));
            }
        }
        return request;
    }

    private void setAcl(String bucketName, String key, String versionId, CannedAccessControlList cannedAcl) {
        Request<Void> request = this.createRequest(bucketName, key, null, HttpMethodName.PUT);
        request.addParameter("acl", null);
        request.addHeader("x-amz-acl", cannedAcl.toString());
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        this.signRequest(request, bucketName, key);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    private void setAcl(String bucketName, String key, String versionId, AccessControlList acl) {
        Request<Void> request = this.createRequest(bucketName, key, null, HttpMethodName.PUT);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        byte[] aclAsXml = new AclXmlFactory().convertToXmlByteArray(acl);
        request.addHeader("Content-Type", "text/plain");
        request.addHeader("Content-Length", String.valueOf(aclAsXml.length));
        this.signRequest(request, bucketName, key);
        request.setContent(new ByteArrayInputStream(aclAsXml));
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        this.client.execute(request, this.voidResponseHandler, this.errorResponseHandler, executionContext);
    }

    protected <T> void signRequest(Request<T> request, String bucketName, String key) {
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                requestHandler.beforeRequest(request);
            }
        }
        AWSCredentials credentials = this.awsCredentials;
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        if (credentials == null) {
            return;
        }
        if (request.getHeaders().get("Content-Type") == null) {
            request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        }
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? ServiceUtils.urlEncode(key) : "");
        new S3Signer(request.getHttpMethod().toString(), resourcePath).sign(request, credentials);
    }

    private <T> void presignRequest(Request<T> request, HttpMethod methodName, String bucketName, String key, Date expiration, String subResource) {
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                requestHandler.beforeRequest(request);
            }
        }
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? ServiceUtils.urlEncode(key) : "") + (subResource != null ? "?" + subResource : "");
        AWSCredentials credentials = this.awsCredentials;
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        new S3QueryStringSigner(methodName.toString(), resourcePath, expiration).sign(request, credentials);
        if (request.getHeaders().containsKey("x-amz-security-token")) {
            String value = request.getHeaders().get("x-amz-security-token");
            request.addParameter("x-amz-security-token", value);
            request.getHeaders().remove("x-amz-security-token");
        }
    }

    private URI convertToVirtualHostEndpoint(String bucketName) {
        try {
            return new URI(this.endpoint.getScheme() + "://" + bucketName + "." + this.endpoint.getAuthority());
        }
        catch (URISyntaxException e) {
            throw new AmazonClientException("Can't turn bucket name into a URI: " + e.getMessage(), e);
        }
    }

    protected static void populateRequestMetadata(Request<Void> request, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                request.addHeader("x-amz-meta-" + entry.getKey(), entry.getValue());
            }
        }
    }

    private void populateRequestWithMfaDetails(Request<Void> request, MultiFactorAuthentication mfa) {
        if (mfa == null) {
            return;
        }
        String endpoint = request.getEndpoint().toString();
        if (endpoint.startsWith("http://")) {
            String httpsEndpoint = endpoint.replace("http://", "https://");
            request.setEndpoint(URI.create(httpsEndpoint));
            log.info((Object)"Overriding current endpoint to use HTTPS as required by S3 for requests containing an MFA header");
        }
        request.addHeader("x-amz-mfa", mfa.getDeviceSerialNumber() + " " + mfa.getToken());
    }

    private static void populateRequestWithCopyObjectParameters(Request<Void> request, CopyObjectRequest copyObjectRequest) {
        ObjectMetadata newObjectMetadata;
        String copySourceHeader = "/" + ServiceUtils.urlEncode(copyObjectRequest.getSourceBucketName()) + "/" + ServiceUtils.urlEncode(copyObjectRequest.getSourceKey());
        if (copyObjectRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyObjectRequest.getSourceVersionId();
        }
        request.addHeader("x-amz-copy-source", copySourceHeader);
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyObjectRequest.getNonmatchingETagConstraints());
        if (copyObjectRequest.getCannedAccessControlList() != null) {
            request.addHeader("x-amz-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", copyObjectRequest.getStorageClass());
        }
        if ((newObjectMetadata = copyObjectRequest.getNewObjectMetadata()) != null) {
            request.addHeader("x-amz-metadata-directive", "REPLACE");
            AmazonS3Client.populateRequestMetadata(request, newObjectMetadata);
        }
    }

    private static void addDateHeader(Request<?> request, String header, Date value) {
        if (value != null) {
            request.addHeader(header, ServiceUtils.formatRfc822Date(value));
        }
    }

    private static void addStringListHeader(Request<?> request, String header, List<String> values) {
        if (values != null && !values.isEmpty()) {
            request.addHeader(header, ServiceUtils.join(values));
        }
    }

    private static void addResponseHeaderParameters(Request<?> request, ResponseHeaderOverrides responseHeaders) {
        if (responseHeaders != null) {
            if (responseHeaders.getCacheControl() != null) {
                request.addParameter("response-cache-control", responseHeaders.getCacheControl());
            }
            if (responseHeaders.getContentDisposition() != null) {
                request.addParameter("response-content-disposition", responseHeaders.getContentDisposition());
            }
            if (responseHeaders.getContentEncoding() != null) {
                request.addParameter("response-content-encoding", responseHeaders.getContentEncoding());
            }
            if (responseHeaders.getContentLanguage() != null) {
                request.addParameter("response-content-language", responseHeaders.getContentLanguage());
            }
            if (responseHeaders.getContentType() != null) {
                request.addParameter("response-content-type", responseHeaders.getContentType());
            }
            if (responseHeaders.getExpires() != null) {
                request.addParameter("response-expires", responseHeaders.getExpires());
            }
        }
    }
}

