/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTagsRequestMarshaller
implements Marshaller<Request<DeleteTagsRequest>, DeleteTagsRequest> {
    @Override
    public Request<DeleteTagsRequest> marshall(DeleteTagsRequest deleteTagsRequest) {
        DefaultRequest<DeleteTagsRequest> request = new DefaultRequest<DeleteTagsRequest>(deleteTagsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteTags");
        request.addParameter("Version", "2011-01-01");
        if (deleteTagsRequest != null) {
            List<String> resourcesList = deleteTagsRequest.getResources();
            int resourcesListIndex = 1;
            for (String resourcesListValue : resourcesList) {
                if (resourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex, StringUtils.fromString(resourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (deleteTagsRequest != null) {
            List<Tag> tagsList = deleteTagsRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null && tagsListValue.getKey() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue != null && tagsListValue.getValue() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

