/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureHealthCheckRequestMarshaller
implements Marshaller<Request<ConfigureHealthCheckRequest>, ConfigureHealthCheckRequest> {
    @Override
    public Request<ConfigureHealthCheckRequest> marshall(ConfigureHealthCheckRequest configureHealthCheckRequest) {
        DefaultRequest<ConfigureHealthCheckRequest> request = new DefaultRequest<ConfigureHealthCheckRequest>(configureHealthCheckRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ConfigureHealthCheck");
        request.addParameter("Version", "2010-07-01");
        if (configureHealthCheckRequest != null && configureHealthCheckRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString(configureHealthCheckRequest.getLoadBalancerName()));
        }
        if (configureHealthCheckRequest != null) {
            HealthCheck healthCheck = configureHealthCheckRequest.getHealthCheck();
            if (healthCheck != null && healthCheck.getTarget() != null) {
                request.addParameter("HealthCheck.Target", StringUtils.fromString(healthCheck.getTarget()));
            }
            if (healthCheck != null && healthCheck.getInterval() != null) {
                request.addParameter("HealthCheck.Interval", StringUtils.fromInteger(healthCheck.getInterval()));
            }
            if (healthCheck != null && healthCheck.getTimeout() != null) {
                request.addParameter("HealthCheck.Timeout", StringUtils.fromInteger(healthCheck.getTimeout()));
            }
            if (healthCheck != null && healthCheck.getUnhealthyThreshold() != null) {
                request.addParameter("HealthCheck.UnhealthyThreshold", StringUtils.fromInteger(healthCheck.getUnhealthyThreshold()));
            }
            if (healthCheck != null && healthCheck.getHealthyThreshold() != null) {
                request.addParameter("HealthCheck.HealthyThreshold", StringUtils.fromInteger(healthCheck.getHealthyThreshold()));
            }
        }
        return request;
    }
}

