/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyResult;
import com.amazonaws.services.identitymanagement.model.CreateGroupRequest;
import com.amazonaws.services.identitymanagement.model.CreateGroupResult;
import com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateLoginProfileResult;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.services.identitymanagement.model.CreateUserResult;
import com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteGroupRequest;
import com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest;
import com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserRequest;
import com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetGroupPolicyResult;
import com.amazonaws.services.identitymanagement.model.GetGroupRequest;
import com.amazonaws.services.identitymanagement.model.GetGroupResult;
import com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetLoginProfileResult;
import com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest;
import com.amazonaws.services.identitymanagement.model.GetServerCertificateResult;
import com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetUserPolicyResult;
import com.amazonaws.services.identitymanagement.model.GetUserRequest;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysResult;
import com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListGroupPoliciesResult;
import com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest;
import com.amazonaws.services.identitymanagement.model.ListGroupsForUserResult;
import com.amazonaws.services.identitymanagement.model.ListGroupsRequest;
import com.amazonaws.services.identitymanagement.model.ListGroupsResult;
import com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest;
import com.amazonaws.services.identitymanagement.model.ListMFADevicesResult;
import com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest;
import com.amazonaws.services.identitymanagement.model.ListServerCertificatesResult;
import com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest;
import com.amazonaws.services.identitymanagement.model.ListSigningCertificatesResult;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesResult;
import com.amazonaws.services.identitymanagement.model.ListUsersRequest;
import com.amazonaws.services.identitymanagement.model.ListUsersResult;
import com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest;
import com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.UpdateGroupRequest;
import com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest;
import com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest;
import com.amazonaws.services.identitymanagement.model.UpdateUserRequest;
import com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest;
import com.amazonaws.services.identitymanagement.model.UploadServerCertificateResult;
import com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest;
import com.amazonaws.services.identitymanagement.model.UploadSigningCertificateResult;
import com.amazonaws.services.identitymanagement.model.transform.AddUserToGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateAccessKeyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateAccessKeyResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateGroupResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateLoginProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateLoginProfileResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateUserResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeactivateMFADeviceRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteAccessKeyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteConflictExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteGroupPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteLoginProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteServerCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteSigningCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteUserPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DuplicateCertificateExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.EnableMFADeviceRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.EntityAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.EntityTemporarilyUnmodifiableExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetGroupPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetGroupPolicyResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetGroupResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetLoginProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetLoginProfileResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetServerCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetServerCertificateResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetUserPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetUserPolicyResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetUserResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.InvalidAuthenticationCodeExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.InvalidCertificateExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.KeyPairMismatchExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListAccessKeysRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListAccessKeysResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupPoliciesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupsForUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupsForUserResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupsRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupsResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListMFADevicesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListMFADevicesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListServerCertificatesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListServerCertificatesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListSigningCertificatesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListSigningCertificatesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListUserPoliciesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListUserPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListUsersRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListUsersResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.MalformedCertificateExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.NoSuchEntityExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.PutGroupPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.PutUserPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.RemoveUserFromGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ResyncMFADeviceRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateAccessKeyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateLoginProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateServerCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateSigningCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UploadServerCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UploadServerCertificateResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UploadSigningCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UploadSigningCertificateResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonIdentityManagementClient
extends AmazonWebServiceClient
implements AmazonIdentityManagement {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    protected final HttpClient client;
    private List<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();
    private QueryStringSigner signer;

    public AmazonIdentityManagementClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonIdentityManagementClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new DuplicateCertificateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new EntityAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new KeyPairMismatchExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DeleteConflictExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidAuthenticationCodeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new EntityTemporarilyUnmodifiableExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MalformedCertificateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidCertificateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MalformedPolicyDocumentExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchEntityExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("iam.amazonaws.com");
        this.signer = new QueryStringSigner(awsCredentials);
        this.requestHandlers = new HandlerChainFactory().newRequestHandlerChain("/com/amazonaws/services/identitymanagement/request.handlers");
        this.client = new HttpClient(clientConfiguration);
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest listGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListGroupsRequest> request = new ListGroupsRequestMarshaller().marshall(listGroupsRequest);
        return this.invoke(request, new ListGroupsResultStaxUnmarshaller());
    }

    @Override
    public void deleteAccessKey(DeleteAccessKeyRequest deleteAccessKeyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteAccessKeyRequest> request = new DeleteAccessKeyRequestMarshaller().marshall(deleteAccessKeyRequest);
        this.invoke(request, null);
    }

    @Override
    public ListSigningCertificatesResult listSigningCertificates(ListSigningCertificatesRequest listSigningCertificatesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListSigningCertificatesRequest> request = new ListSigningCertificatesRequestMarshaller().marshall(listSigningCertificatesRequest);
        return this.invoke(request, new ListSigningCertificatesResultStaxUnmarshaller());
    }

    @Override
    public UploadSigningCertificateResult uploadSigningCertificate(UploadSigningCertificateRequest uploadSigningCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<UploadSigningCertificateRequest> request = new UploadSigningCertificateRequestMarshaller().marshall(uploadSigningCertificateRequest);
        return this.invoke(request, new UploadSigningCertificateResultStaxUnmarshaller());
    }

    @Override
    public void deleteUserPolicy(DeleteUserPolicyRequest deleteUserPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteUserPolicyRequest> request = new DeleteUserPolicyRequestMarshaller().marshall(deleteUserPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public void putUserPolicy(PutUserPolicyRequest putUserPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutUserPolicyRequest> request = new PutUserPolicyRequestMarshaller().marshall(putUserPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public ListServerCertificatesResult listServerCertificates(ListServerCertificatesRequest listServerCertificatesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListServerCertificatesRequest> request = new ListServerCertificatesRequestMarshaller().marshall(listServerCertificatesRequest);
        return this.invoke(request, new ListServerCertificatesResultStaxUnmarshaller());
    }

    @Override
    public GetUserPolicyResult getUserPolicy(GetUserPolicyRequest getUserPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetUserPolicyRequest> request = new GetUserPolicyRequestMarshaller().marshall(getUserPolicyRequest);
        return this.invoke(request, new GetUserPolicyResultStaxUnmarshaller());
    }

    @Override
    public void updateLoginProfile(UpdateLoginProfileRequest updateLoginProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateLoginProfileRequest> request = new UpdateLoginProfileRequestMarshaller().marshall(updateLoginProfileRequest);
        this.invoke(request, null);
    }

    @Override
    public void updateServerCertificate(UpdateServerCertificateRequest updateServerCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateServerCertificateRequest> request = new UpdateServerCertificateRequestMarshaller().marshall(updateServerCertificateRequest);
        this.invoke(request, null);
    }

    @Override
    public void updateUser(UpdateUserRequest updateUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateUserRequest> request = new UpdateUserRequestMarshaller().marshall(updateUserRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteLoginProfile(DeleteLoginProfileRequest deleteLoginProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteLoginProfileRequest> request = new DeleteLoginProfileRequestMarshaller().marshall(deleteLoginProfileRequest);
        this.invoke(request, null);
    }

    @Override
    public void updateSigningCertificate(UpdateSigningCertificateRequest updateSigningCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateSigningCertificateRequest> request = new UpdateSigningCertificateRequestMarshaller().marshall(updateSigningCertificateRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteGroupPolicy(DeleteGroupPolicyRequest deleteGroupPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteGroupPolicyRequest> request = new DeleteGroupPolicyRequestMarshaller().marshall(deleteGroupPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest listUsersRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListUsersRequest> request = new ListUsersRequestMarshaller().marshall(listUsersRequest);
        return this.invoke(request, new ListUsersResultStaxUnmarshaller());
    }

    @Override
    public void updateGroup(UpdateGroupRequest updateGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateGroupRequest> request = new UpdateGroupRequestMarshaller().marshall(updateGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public GetServerCertificateResult getServerCertificate(GetServerCertificateRequest getServerCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetServerCertificateRequest> request = new GetServerCertificateRequestMarshaller().marshall(getServerCertificateRequest);
        return this.invoke(request, new GetServerCertificateResultStaxUnmarshaller());
    }

    @Override
    public void putGroupPolicy(PutGroupPolicyRequest putGroupPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutGroupPolicyRequest> request = new PutGroupPolicyRequestMarshaller().marshall(putGroupPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest createUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateUserRequest> request = new CreateUserRequestMarshaller().marshall(createUserRequest);
        return this.invoke(request, new CreateUserResultStaxUnmarshaller());
    }

    @Override
    public void deleteSigningCertificate(DeleteSigningCertificateRequest deleteSigningCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteSigningCertificateRequest> request = new DeleteSigningCertificateRequestMarshaller().marshall(deleteSigningCertificateRequest);
        this.invoke(request, null);
    }

    @Override
    public void enableMFADevice(EnableMFADeviceRequest enableMFADeviceRequest) throws AmazonServiceException, AmazonClientException {
        Request<EnableMFADeviceRequest> request = new EnableMFADeviceRequestMarshaller().marshall(enableMFADeviceRequest);
        this.invoke(request, null);
    }

    @Override
    public ListUserPoliciesResult listUserPolicies(ListUserPoliciesRequest listUserPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListUserPoliciesRequest> request = new ListUserPoliciesRequestMarshaller().marshall(listUserPoliciesRequest);
        return this.invoke(request, new ListUserPoliciesResultStaxUnmarshaller());
    }

    @Override
    public ListAccessKeysResult listAccessKeys(ListAccessKeysRequest listAccessKeysRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListAccessKeysRequest> request = new ListAccessKeysRequestMarshaller().marshall(listAccessKeysRequest);
        return this.invoke(request, new ListAccessKeysResultStaxUnmarshaller());
    }

    @Override
    public GetLoginProfileResult getLoginProfile(GetLoginProfileRequest getLoginProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetLoginProfileRequest> request = new GetLoginProfileRequestMarshaller().marshall(getLoginProfileRequest);
        return this.invoke(request, new GetLoginProfileResultStaxUnmarshaller());
    }

    @Override
    public ListGroupsForUserResult listGroupsForUser(ListGroupsForUserRequest listGroupsForUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListGroupsForUserRequest> request = new ListGroupsForUserRequestMarshaller().marshall(listGroupsForUserRequest);
        return this.invoke(request, new ListGroupsForUserResultStaxUnmarshaller());
    }

    @Override
    public CreateGroupResult createGroup(CreateGroupRequest createGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateGroupRequest> request = new CreateGroupRequestMarshaller().marshall(createGroupRequest);
        return this.invoke(request, new CreateGroupResultStaxUnmarshaller());
    }

    @Override
    public UploadServerCertificateResult uploadServerCertificate(UploadServerCertificateRequest uploadServerCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<UploadServerCertificateRequest> request = new UploadServerCertificateRequestMarshaller().marshall(uploadServerCertificateRequest);
        return this.invoke(request, new UploadServerCertificateResultStaxUnmarshaller());
    }

    @Override
    public GetGroupPolicyResult getGroupPolicy(GetGroupPolicyRequest getGroupPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetGroupPolicyRequest> request = new GetGroupPolicyRequestMarshaller().marshall(getGroupPolicyRequest);
        return this.invoke(request, new GetGroupPolicyResultStaxUnmarshaller());
    }

    @Override
    public void deleteUser(DeleteUserRequest deleteUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteUserRequest> request = new DeleteUserRequestMarshaller().marshall(deleteUserRequest);
        this.invoke(request, null);
    }

    @Override
    public void deactivateMFADevice(DeactivateMFADeviceRequest deactivateMFADeviceRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeactivateMFADeviceRequest> request = new DeactivateMFADeviceRequestMarshaller().marshall(deactivateMFADeviceRequest);
        this.invoke(request, null);
    }

    @Override
    public void removeUserFromGroup(RemoveUserFromGroupRequest removeUserFromGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<RemoveUserFromGroupRequest> request = new RemoveUserFromGroupRequestMarshaller().marshall(removeUserFromGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteServerCertificate(DeleteServerCertificateRequest deleteServerCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteServerCertificateRequest> request = new DeleteServerCertificateRequestMarshaller().marshall(deleteServerCertificateRequest);
        this.invoke(request, null);
    }

    @Override
    public ListGroupPoliciesResult listGroupPolicies(ListGroupPoliciesRequest listGroupPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListGroupPoliciesRequest> request = new ListGroupPoliciesRequestMarshaller().marshall(listGroupPoliciesRequest);
        return this.invoke(request, new ListGroupPoliciesResultStaxUnmarshaller());
    }

    @Override
    public CreateLoginProfileResult createLoginProfile(CreateLoginProfileRequest createLoginProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateLoginProfileRequest> request = new CreateLoginProfileRequestMarshaller().marshall(createLoginProfileRequest);
        return this.invoke(request, new CreateLoginProfileResultStaxUnmarshaller());
    }

    @Override
    public CreateAccessKeyResult createAccessKey(CreateAccessKeyRequest createAccessKeyRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateAccessKeyRequest> request = new CreateAccessKeyRequestMarshaller().marshall(createAccessKeyRequest);
        return this.invoke(request, new CreateAccessKeyResultStaxUnmarshaller());
    }

    @Override
    public GetUserResult getUser(GetUserRequest getUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetUserRequest> request = new GetUserRequestMarshaller().marshall(getUserRequest);
        return this.invoke(request, new GetUserResultStaxUnmarshaller());
    }

    @Override
    public void resyncMFADevice(ResyncMFADeviceRequest resyncMFADeviceRequest) throws AmazonServiceException, AmazonClientException {
        Request<ResyncMFADeviceRequest> request = new ResyncMFADeviceRequestMarshaller().marshall(resyncMFADeviceRequest);
        this.invoke(request, null);
    }

    @Override
    public ListMFADevicesResult listMFADevices(ListMFADevicesRequest listMFADevicesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListMFADevicesRequest> request = new ListMFADevicesRequestMarshaller().marshall(listMFADevicesRequest);
        return this.invoke(request, new ListMFADevicesResultStaxUnmarshaller());
    }

    @Override
    public void updateAccessKey(UpdateAccessKeyRequest updateAccessKeyRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateAccessKeyRequest> request = new UpdateAccessKeyRequestMarshaller().marshall(updateAccessKeyRequest);
        this.invoke(request, null);
    }

    @Override
    public void addUserToGroup(AddUserToGroupRequest addUserToGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddUserToGroupRequest> request = new AddUserToGroupRequestMarshaller().marshall(addUserToGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public GetGroupResult getGroup(GetGroupRequest getGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetGroupRequest> request = new GetGroupRequestMarshaller().marshall(getGroupRequest);
        return this.invoke(request, new GetGroupResultStaxUnmarshaller());
    }

    @Override
    public void deleteGroup(DeleteGroupRequest deleteGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteGroupRequest> request = new DeleteGroupRequestMarshaller().marshall(deleteGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public ListGroupsResult listGroups() throws AmazonServiceException, AmazonClientException {
        return this.listGroups(new ListGroupsRequest());
    }

    @Override
    public ListSigningCertificatesResult listSigningCertificates() throws AmazonServiceException, AmazonClientException {
        return this.listSigningCertificates(new ListSigningCertificatesRequest());
    }

    @Override
    public ListServerCertificatesResult listServerCertificates() throws AmazonServiceException, AmazonClientException {
        return this.listServerCertificates(new ListServerCertificatesRequest());
    }

    @Override
    public ListUsersResult listUsers() throws AmazonServiceException, AmazonClientException {
        return this.listUsers(new ListUsersRequest());
    }

    @Override
    public ListAccessKeysResult listAccessKeys() throws AmazonServiceException, AmazonClientException {
        return this.listAccessKeys(new ListAccessKeysRequest());
    }

    @Override
    public CreateAccessKeyResult createAccessKey() throws AmazonServiceException, AmazonClientException {
        return this.createAccessKey(new CreateAccessKeyRequest());
    }

    @Override
    public GetUserResult getUser() throws AmazonServiceException, AmazonClientException {
        return this.getUser(new GetUserRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                request = requestHandler.handleRequest(request);
            }
        }
        try {
            this.signer.sign(request);
        }
        catch (SignatureException e) {
            throw new AmazonServiceException("Unable to sign request", e);
        }
        HttpRequest httpRequest = this.convertToHttpRequest(request, HttpMethodName.POST);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(httpRequest, responseHandler, errorResponseHandler);
    }
}

