/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeLicensesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeLicensesRequestMarshaller
implements Marshaller<Request<DescribeLicensesRequest>, DescribeLicensesRequest> {
    @Override
    public Request<DescribeLicensesRequest> marshall(DescribeLicensesRequest describeLicensesRequest) {
        DefaultRequest<DescribeLicensesRequest> request = new DefaultRequest<DescribeLicensesRequest>(describeLicensesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeLicenses");
        request.addParameter("Version", "2010-08-31");
        if (describeLicensesRequest != null) {
            List<String> licenseIdsList = describeLicensesRequest.getLicenseIds();
            int licenseIdsListIndex = 1;
            for (String licenseIdsListValue : licenseIdsList) {
                if (licenseIdsListValue != null) {
                    request.addParameter("LicenseId." + licenseIdsListIndex, StringUtils.fromString(licenseIdsListValue));
                }
                ++licenseIdsListIndex;
            }
        }
        if (describeLicensesRequest != null) {
            List<Filter> filtersList = describeLicensesRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null && filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (filtersListValue != null) {
                    List<String> valuesList = filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

