/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3ErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    @Override
    public AmazonServiceException handle(HttpResponse errorResponse) throws Exception {
        if (errorResponse.getContent() == null || errorResponse.getRequest().getMethodName() == HttpMethodName.HEAD) {
            String requestId = errorResponse.getHeaders().get("x-amz-request-id");
            String extendedRequestId = errorResponse.getHeaders().get("x-amz-id-2");
            AmazonS3Exception ase = new AmazonS3Exception(errorResponse.getStatusText());
            ase.setStatusCode(errorResponse.getStatusCode());
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(extendedRequestId);
            this.fillInErrorType(ase, errorResponse);
            return ase;
        }
        Document document = XpathUtils.documentFrom(errorResponse.getContent());
        String message = XpathUtils.asString("Error/Message", document);
        String errorCode = XpathUtils.asString("Error/Code", document);
        String requestId = XpathUtils.asString("Error/RequestId", document);
        String extendedRequestId = XpathUtils.asString("Error/HostId", document);
        AmazonS3Exception ase = new AmazonS3Exception(message);
        ase.setStatusCode(errorResponse.getStatusCode());
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        ase.setExtendedRequestId(extendedRequestId);
        this.fillInErrorType(ase, errorResponse);
        return ase;
    }

    private void fillInErrorType(AmazonServiceException ase, HttpResponse errorResponse) {
        if (errorResponse.getStatusCode() >= 500) {
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
        } else {
            ase.setErrorType(AmazonServiceException.ErrorType.Client);
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

