/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    @Override
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        DefaultRequest<DescribeSnapshotsRequest> request = new DefaultRequest<DescribeSnapshotsRequest>(describeSnapshotsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2010-06-15");
        if (describeSnapshotsRequest != null) {
            List<String> snapshotIdsList = describeSnapshotsRequest.getSnapshotIds();
            int snapshotIdsListIndex = 1;
            for (String snapshotIdsListValue : snapshotIdsList) {
                if (snapshotIdsListValue != null) {
                    request.addParameter("SnapshotId." + snapshotIdsListIndex, StringUtils.fromString(snapshotIdsListValue));
                }
                ++snapshotIdsListIndex;
            }
        }
        if (describeSnapshotsRequest != null) {
            List<String> ownerIdsList = describeSnapshotsRequest.getOwnerIds();
            int ownerIdsListIndex = 1;
            for (String ownerIdsListValue : ownerIdsList) {
                if (ownerIdsListValue != null) {
                    request.addParameter("Owner." + ownerIdsListIndex, StringUtils.fromString(ownerIdsListValue));
                }
                ++ownerIdsListIndex;
            }
        }
        if (describeSnapshotsRequest != null) {
            List<String> restorableByUserIdsList = describeSnapshotsRequest.getRestorableByUserIds();
            int restorableByUserIdsListIndex = 1;
            for (String restorableByUserIdsListValue : restorableByUserIdsList) {
                if (restorableByUserIdsListValue != null) {
                    request.addParameter("RestorableBy." + restorableByUserIdsListIndex, StringUtils.fromString(restorableByUserIdsListValue));
                }
                ++restorableByUserIdsListIndex;
            }
        }
        return request;
    }
}

