/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockDeviceMappingStaxUnmarshaller
implements Unmarshaller<BlockDeviceMapping, StaxUnmarshallerContext> {
    private static BlockDeviceMappingStaxUnmarshaller instance;

    @Override
    public BlockDeviceMapping unmarshall(StaxUnmarshallerContext context) throws Exception {
        BlockDeviceMapping blockDeviceMapping = new BlockDeviceMapping();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return blockDeviceMapping;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("VirtualName", targetDepth)) {
                    blockDeviceMapping.setVirtualName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DeviceName", targetDepth)) continue;
                blockDeviceMapping.setDeviceName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return blockDeviceMapping;
    }

    public static BlockDeviceMappingStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BlockDeviceMappingStaxUnmarshaller();
        }
        return instance;
    }
}

