/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy;

import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.internal.JsonPolicyWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy {
    private static final String DEFAULT_POLICY_VERSION = "2008-10-17";
    private String id;
    private String version = "2008-10-17";
    private List<Statement> statements = new ArrayList<Statement>();

    public Policy() {
    }

    public Policy(String id) {
        this.id = id;
    }

    public Policy(String id, Collection<Statement> statements) {
        this.statements = new ArrayList<Statement>(statements);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Policy withId(String id) {
        this.setId(id);
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Collection<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(Collection<Statement> statements) {
        this.statements = new ArrayList<Statement>(statements);
    }

    public Policy withStatements(Statement ... statements) {
        this.setStatements(Arrays.asList(statements));
        return this;
    }

    public String toJson() {
        return new JsonPolicyWriter().writePolicyToString(this);
    }
}

