/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.ResponseMetadata;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseMetadataUnmarshaller<T>
implements Unmarshaller<ResponseMetadata<T>, Node> {
    private String requestIdXpath = "ResponseMetadata/RequestId";
    private static final String STANDARD_REQUEST_ID_XPATH = "ResponseMetadata/RequestId";

    public void setRequestIdPath(String requestIdPath) {
        this.requestIdXpath = requestIdPath;
    }

    @Override
    public ResponseMetadata<T> unmarshall(Node in) throws Exception {
        Node rootNode = in.getFirstChild();
        String requestId = XpathUtils.asString(this.requestIdXpath, rootNode);
        if (requestId == null || requestId.length() == 0) {
            return null;
        }
        ResponseMetadata metadata = new ResponseMetadata();
        metadata.setRequestId(requestId);
        return metadata;
    }
}

