/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.transform.BlockDeviceMappingStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.PlacementStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunInstancesRequestStaxUnmarshaller
implements Unmarshaller<RunInstancesRequest, StaxUnmarshallerContext> {
    private static RunInstancesRequestStaxUnmarshaller instance;

    @Override
    public RunInstancesRequest unmarshall(StaxUnmarshallerContext context) throws Exception {
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent event;
            if ((event = context.nextEvent()).isEndDocument()) {
                return runInstancesRequest;
            }
            if (event.isAttribute() || event.isStartElement()) {
                if (context.testExpression("ImageId", targetDepth)) {
                    runInstancesRequest.setImageId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinCount", targetDepth)) {
                    runInstancesRequest.setMinCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxCount", targetDepth)) {
                    runInstancesRequest.setMaxCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KeyName", targetDepth)) {
                    runInstancesRequest.setKeyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecurityGroup/SecurityGroup", targetDepth)) {
                    runInstancesRequest.getSecurityGroups().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UserData", targetDepth)) {
                    runInstancesRequest.setUserData(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    runInstancesRequest.setInstanceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Placement", targetDepth)) {
                    runInstancesRequest.setPlacement(PlacementStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KernelId", targetDepth)) {
                    runInstancesRequest.setKernelId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RamdiskId", targetDepth)) {
                    runInstancesRequest.setRamdiskId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BlockDeviceMapping/BlockDeviceMapping", targetDepth)) {
                    runInstancesRequest.getBlockDeviceMappings().add(BlockDeviceMappingStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("monitoring/enabled", targetDepth)) {
                    runInstancesRequest.setMonitoring(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubnetId", targetDepth)) {
                    runInstancesRequest.setSubnetId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("disableApiTermination", targetDepth)) {
                    runInstancesRequest.setDisableApiTermination(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instanceInitiatedShutdownBehavior", targetDepth)) continue;
                runInstancesRequest.setInstanceInitiatedShutdownBehavior(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (event.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return runInstancesRequest;
    }

    public static RunInstancesRequestStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RunInstancesRequestStaxUnmarshaller();
        }
        return instance;
    }
}

