/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.ResponseMetadata;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxUnmarshallerContext {
    private XMLEvent currentEvent;
    private final XMLEventReader eventReader;
    public final Stack<String> stack = new Stack();
    private int currentDepth = 0;
    private final ResponseMetadata<?> responseMetadata;
    private String stackString = "";
    private Iterator<?> attributeIterator;

    public StaxUnmarshallerContext(XMLEventReader eventReader, ResponseMetadata<?> responseMetadata) {
        this.eventReader = eventReader;
        this.responseMetadata = responseMetadata;
    }

    public String readText() throws XMLStreamException {
        if (this.currentEvent.isAttribute()) {
            Attribute attribute = (Attribute)this.currentEvent;
            return attribute.getValue();
        }
        XMLEvent event = this.eventReader.peek();
        if (event.getEventType() == 4) {
            this.eventReader.nextEvent();
            return event.asCharacters().getData();
        }
        if (event.getEventType() == 2) {
            return "";
        }
        throw new RuntimeException("Encountered unexpected event: " + event.toString());
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public boolean testExpression(String expression) {
        return this.stackString.endsWith(expression);
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent nextEvent;
        this.currentEvent = this.attributeIterator != null && this.attributeIterator.hasNext() ? (XMLEvent)this.attributeIterator.next() : this.eventReader.nextEvent();
        if (this.currentEvent.isStartElement()) {
            this.attributeIterator = this.currentEvent.asStartElement().getAttributes();
        }
        this.updateContext(this.currentEvent);
        if (this.testExpression("ResponseMetadata/RequestId") && (nextEvent = this.eventReader.peek()).isCharacters()) {
            this.responseMetadata.setRequestId(nextEvent.asCharacters().getData());
        }
        return this.currentEvent;
    }

    private void updateContext(XMLEvent event) {
        if (event == null) {
            return;
        }
        if (event.isEndElement()) {
            --this.currentDepth;
            this.stack.pop();
            this.stackString = "";
            for (String s : this.stack) {
                this.stackString = this.stackString + "/" + s;
            }
        } else if (event.isStartElement()) {
            ++this.currentDepth;
            this.stack.push(event.asStartElement().getName().getLocalPart());
            this.stackString = this.stackString + "/" + event.asStartElement().getName().getLocalPart();
        } else if (event.isAttribute()) {
            Attribute attribute = (Attribute)event;
            this.stackString = "";
            for (String s : this.stack) {
                this.stackString = this.stackString + "/" + s;
            }
            this.stackString = this.stackString + "/@" + attribute.getName().getLocalPart();
        }
    }
}

