/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.transform.ListenerUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLoadBalancerRequestUnmarshaller
implements Unmarshaller<CreateLoadBalancerRequest, Node> {
    @Override
    public CreateLoadBalancerRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        CreateLoadBalancerRequest createLoadBalancerRequest = new CreateLoadBalancerRequest();
        Node loadBalancerNameNode = XpathUtils.asNode("LoadBalancerName", node);
        createLoadBalancerRequest.setLoadBalancerName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(loadBalancerNameNode));
        NodeList listenersNodes = XpathUtils.asNodeList("Listeners/member", node);
        for (int listenersIndex = 0; listenersIndex < XpathUtils.nodeLength(listenersNodes); ++listenersIndex) {
            Node listenersNode = listenersNodes.item(listenersIndex);
            createLoadBalancerRequest.getListeners().add(new ListenerUnmarshaller().unmarshall(listenersNode));
            listenersNode.getParentNode().removeChild(listenersNode);
        }
        NodeList availabilityZonesNodes = XpathUtils.asNodeList("AvailabilityZones/member", node);
        for (int availabilityZonesIndex = 0; availabilityZonesIndex < XpathUtils.nodeLength(availabilityZonesNodes); ++availabilityZonesIndex) {
            Node availabilityZonesNode = availabilityZonesNodes.item(availabilityZonesIndex);
            createLoadBalancerRequest.getAvailabilityZones().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(availabilityZonesNode));
            availabilityZonesNode.getParentNode().removeChild(availabilityZonesNode);
        }
        return createLoadBalancerRequest;
    }
}

