/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeInstancesRequestMarshaller
implements Marshaller<Request<DescribeInstancesRequest>, DescribeInstancesRequest> {
    @Override
    public Request<DescribeInstancesRequest> marshall(DescribeInstancesRequest describeInstancesRequest) {
        DefaultRequest<DescribeInstancesRequest> request = new DefaultRequest<DescribeInstancesRequest>(describeInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstances");
        request.addParameter("Version", "2009-11-30");
        if (describeInstancesRequest != null) {
            List<String> instanceIdsList = describeInstancesRequest.getInstanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

