/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.Metric;
import com.amazonaws.services.cloudwatch.model.transform.DimensionUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricUnmarshaller
implements Unmarshaller<Metric, Node> {
    @Override
    public Metric unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        Metric metric = new Metric();
        Node measureNameNode = XpathUtils.asNode("MeasureName", node);
        metric.setMeasureName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(measureNameNode));
        NodeList dimensionsNodes = XpathUtils.asNodeList("Dimensions/member", node);
        for (int dimensionsIndex = 0; dimensionsIndex < XpathUtils.nodeLength(dimensionsNodes); ++dimensionsIndex) {
            Node dimensionsNode = dimensionsNodes.item(dimensionsIndex);
            metric.getDimensions().add(new DimensionUnmarshaller().unmarshall(dimensionsNode));
            dimensionsNode.getParentNode().removeChild(dimensionsNode);
        }
        Node namespaceNode = XpathUtils.asNode("Namespace", node);
        metric.setNamespace(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(namespaceNode));
        return metric;
    }
}

