/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.SignatureVersion;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.services.s3.internal.RestUtils;
import com.amazonaws.services.s3.internal.ServiceUtils;
import java.security.SignatureException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Signer<T>
implements Signer<T> {
    private final AWSCredentials credentials;
    private static final Log log = LogFactory.getLog(S3Signer.class);
    private final String httpVerb;
    private final String resourcePath;

    public S3Signer(AWSCredentials credentials, String httpVerb, String resourcePath) {
        this.credentials = credentials;
        this.httpVerb = httpVerb;
        this.resourcePath = resourcePath;
        if (resourcePath == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    @Override
    public void sign(Request<T> request, SignatureVersion version, SigningAlgorithm algorithm) throws SignatureException {
        request.addHeader("Date", ServiceUtils.formatRfc822Date(new Date()));
        String canonicalString = RestUtils.makeS3CanonicalString(this.httpVerb, this.resourcePath, request, null);
        log.debug((Object)("Calculated string to sign:\n\"" + canonicalString + "\""));
        try {
            String signature = ServiceUtils.signWithHmacSha1(this.credentials.getAWSSecretKey(), canonicalString);
            request.addHeader("Authorization", "AWS " + this.credentials.getAWSAccessKeyId() + ":" + signature);
        }
        catch (AmazonClientException e) {
            throw new SignatureException("Unable to sign request: " + e.getMessage(), e);
        }
    }
}

