/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingAsync;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticLoadBalancingAsyncClient
extends AmazonElasticLoadBalancingClient
implements AmazonElasticLoadBalancingAsync {
    private ExecutorService executorService;

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeregisterInstancesFromLoadBalancerResult> deregisterInstancesFromLoadBalancerAsync(final DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeregisterInstancesFromLoadBalancerResult>(){

            @Override
            public DeregisterInstancesFromLoadBalancerResult call() throws Exception {
                return AmazonElasticLoadBalancingAsyncClient.this.deregisterInstancesFromLoadBalancer(deregisterInstancesFromLoadBalancerRequest);
            }
        });
    }

    @Override
    public Future<ConfigureHealthCheckResult> configureHealthCheckAsync(final ConfigureHealthCheckRequest configureHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfigureHealthCheckResult>(){

            @Override
            public ConfigureHealthCheckResult call() throws Exception {
                return AmazonElasticLoadBalancingAsyncClient.this.configureHealthCheck(configureHealthCheckRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteLoadBalancerAsync(final DeleteLoadBalancerRequest deleteLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticLoadBalancingAsyncClient.this.deleteLoadBalancer(deleteLoadBalancerRequest);
                return null;
            }
        });
    }

    @Override
    public Future<RegisterInstancesWithLoadBalancerResult> registerInstancesWithLoadBalancerAsync(final RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterInstancesWithLoadBalancerResult>(){

            @Override
            public RegisterInstancesWithLoadBalancerResult call() throws Exception {
                return AmazonElasticLoadBalancingAsyncClient.this.registerInstancesWithLoadBalancer(registerInstancesWithLoadBalancerRequest);
            }
        });
    }

    @Override
    public Future<CreateLoadBalancerResult> createLoadBalancerAsync(final CreateLoadBalancerRequest createLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateLoadBalancerResult>(){

            @Override
            public CreateLoadBalancerResult call() throws Exception {
                return AmazonElasticLoadBalancingAsyncClient.this.createLoadBalancer(createLoadBalancerRequest);
            }
        });
    }

    @Override
    public Future<EnableAvailabilityZonesForLoadBalancerResult> enableAvailabilityZonesForLoadBalancerAsync(final EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EnableAvailabilityZonesForLoadBalancerResult>(){

            @Override
            public EnableAvailabilityZonesForLoadBalancerResult call() throws Exception {
                return AmazonElasticLoadBalancingAsyncClient.this.enableAvailabilityZonesForLoadBalancer(enableAvailabilityZonesForLoadBalancerRequest);
            }
        });
    }

    @Override
    public Future<DisableAvailabilityZonesForLoadBalancerResult> disableAvailabilityZonesForLoadBalancerAsync(final DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DisableAvailabilityZonesForLoadBalancerResult>(){

            @Override
            public DisableAvailabilityZonesForLoadBalancerResult call() throws Exception {
                return AmazonElasticLoadBalancingAsyncClient.this.disableAvailabilityZonesForLoadBalancer(disableAvailabilityZonesForLoadBalancerRequest);
            }
        });
    }

    @Override
    public Future<DescribeInstanceHealthResult> describeInstanceHealthAsync(final DescribeInstanceHealthRequest describeInstanceHealthRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstanceHealthResult>(){

            @Override
            public DescribeInstanceHealthResult call() throws Exception {
                return AmazonElasticLoadBalancingAsyncClient.this.describeInstanceHealth(describeInstanceHealthRequest);
            }
        });
    }

    @Override
    public Future<DescribeLoadBalancersResult> describeLoadBalancersAsync(final DescribeLoadBalancersRequest describeLoadBalancersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLoadBalancersResult>(){

            @Override
            public DescribeLoadBalancersResult call() throws Exception {
                return AmazonElasticLoadBalancingAsyncClient.this.describeLoadBalancers(describeLoadBalancersRequest);
            }
        });
    }
}

