/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopInstancesRequestUnmarshaller
implements Unmarshaller<StopInstancesRequest, Node> {
    @Override
    public StopInstancesRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        StopInstancesRequest stopInstancesRequest = new StopInstancesRequest();
        NodeList instanceIdsNodes = XpathUtils.asNodeList("InstanceId/InstanceId", node);
        for (int instanceIdsIndex = 0; instanceIdsIndex < XpathUtils.nodeLength(instanceIdsNodes); ++instanceIdsIndex) {
            Node instanceIdsNode = instanceIdsNodes.item(instanceIdsIndex);
            stopInstancesRequest.getInstanceIds().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceIdsNode));
            instanceIdsNode.getParentNode().removeChild(instanceIdsNode);
        }
        Node forceNode = XpathUtils.asNode("force", node);
        stopInstancesRequest.setForce(new SimpleTypeUnmarshallers.BooleanUnmarshaller().unmarshall(forceNode));
        return stopInstancesRequest;
    }
}

