/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.EngineDefaults;
import com.amazonaws.services.rds.model.transform.ParameterUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineDefaultsUnmarshaller
implements Unmarshaller<EngineDefaults, Node> {
    @Override
    public EngineDefaults unmarshall(Node node) throws Exception {
        EngineDefaults engineDefaults = new EngineDefaults();
        Node engineNode = XpathUtils.asNode("Engine", node);
        engineDefaults.setEngine(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(engineNode));
        Node markerNode = XpathUtils.asNode("Marker", node);
        engineDefaults.setMarker(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(markerNode));
        NodeList parametersNodes = XpathUtils.asNodeList("Parameters/Parameter", node);
        for (int parametersIndex = 0; parametersIndex < XpathUtils.nodeLength(parametersNodes); ++parametersIndex) {
            Node parametersNode = parametersNodes.item(parametersIndex);
            engineDefaults.getParameters().add(new ParameterUnmarshaller().unmarshall(parametersNode));
            parametersNode.getParentNode().removeChild(parametersNode);
        }
        return engineDefaults;
    }
}

