/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerDescription {
    private String loadBalancerName;
    private String dNSName;
    private List<Listener> listeners;
    private List<String> availabilityZones;
    private List<Instance> instances;
    private HealthCheck healthCheck;
    private Date createdTime;

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public LoadBalancerDescription withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public String getDNSName() {
        return this.dNSName;
    }

    public void setDNSName(String dNSName) {
        this.dNSName = dNSName;
    }

    public LoadBalancerDescription withDNSName(String dNSName) {
        this.dNSName = dNSName;
        return this;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        return this.listeners;
    }

    public void setListeners(Collection<Listener> listeners) {
        ArrayList<Listener> listenersCopy = new ArrayList<Listener>();
        if (listeners != null) {
            listenersCopy.addAll(listeners);
        }
        this.listeners = listenersCopy;
    }

    public LoadBalancerDescription withListeners(Listener ... listeners) {
        for (Listener value : listeners) {
            this.getListeners().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withListeners(Collection<Listener> listeners) {
        ArrayList<Listener> listenersCopy = new ArrayList<Listener>();
        if (listeners != null) {
            listenersCopy.addAll(listeners);
        }
        this.listeners = listenersCopy;
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<String>();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>();
        if (availabilityZones != null) {
            availabilityZonesCopy.addAll(availabilityZones);
        }
        this.availabilityZones = availabilityZonesCopy;
    }

    public LoadBalancerDescription withAvailabilityZones(String ... availabilityZones) {
        for (String value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withAvailabilityZones(Collection<String> availabilityZones) {
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>();
        if (availabilityZones != null) {
            availabilityZonesCopy.addAll(availabilityZones);
        }
        this.availabilityZones = availabilityZonesCopy;
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ArrayList<Instance>();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>();
        if (instances != null) {
            instancesCopy.addAll(instances);
        }
        this.instances = instancesCopy;
    }

    public LoadBalancerDescription withInstances(Instance ... instances) {
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public LoadBalancerDescription withInstances(Collection<Instance> instances) {
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>();
        if (instances != null) {
            instancesCopy.addAll(instances);
        }
        this.instances = instancesCopy;
        return this;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public LoadBalancerDescription withHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
        return this;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public LoadBalancerDescription withCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }
}

