/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.RegisterImageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterImageRequestMarshaller
implements Marshaller<Request<RegisterImageRequest>, RegisterImageRequest> {
    @Override
    public Request<RegisterImageRequest> marshall(RegisterImageRequest registerImageRequest) {
        DefaultRequest<RegisterImageRequest> request = new DefaultRequest<RegisterImageRequest>(registerImageRequest, "AmazonEC2");
        request.addParameter("Action", "RegisterImage");
        request.addParameter("Version", "2009-10-31");
        if (registerImageRequest != null && registerImageRequest.getImageLocation() != null) {
            request.addParameter("ImageLocation", StringUtils.fromString(registerImageRequest.getImageLocation()));
        }
        if (registerImageRequest != null && registerImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(registerImageRequest.getName()));
        }
        if (registerImageRequest != null && registerImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(registerImageRequest.getDescription()));
        }
        if (registerImageRequest != null && registerImageRequest.getArchitecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString(registerImageRequest.getArchitecture()));
        }
        if (registerImageRequest != null && registerImageRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(registerImageRequest.getKernelId()));
        }
        if (registerImageRequest != null && registerImageRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(registerImageRequest.getRamdiskId()));
        }
        if (registerImageRequest != null && registerImageRequest.getRootDeviceName() != null) {
            request.addParameter("RootDeviceName", StringUtils.fromString(registerImageRequest.getRootDeviceName()));
        }
        if (registerImageRequest != null) {
            List<BlockDeviceMapping> blockDeviceMappingsList = registerImageRequest.getBlockDeviceMappings();
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                if (blockDeviceMappingsListValue != null && blockDeviceMappingsListValue.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(blockDeviceMappingsListValue.getVirtualName()));
                }
                if (blockDeviceMappingsListValue != null && blockDeviceMappingsListValue.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(blockDeviceMappingsListValue.getDeviceName()));
                }
                if (blockDeviceMappingsListValue != null) {
                    EbsBlockDevice ebs = blockDeviceMappingsListValue.getEbs();
                    if (ebs != null && ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                    }
                    if (ebs != null && ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                    }
                    if (ebs != null && ebs.isDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.isDeleteOnTermination()));
                    }
                }
                if (blockDeviceMappingsListValue != null && blockDeviceMappingsListValue.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(blockDeviceMappingsListValue.getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        return request;
    }
}

