/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {
    @Override
    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        DefaultRequest<ModifyImageAttributeRequest> request = new DefaultRequest<ModifyImageAttributeRequest>(modifyImageAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2009-10-31");
        if (modifyImageAttributeRequest != null && modifyImageAttributeRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(modifyImageAttributeRequest.getImageId()));
        }
        if (modifyImageAttributeRequest != null && modifyImageAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifyImageAttributeRequest.getAttribute()));
        }
        if (modifyImageAttributeRequest != null && modifyImageAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString(modifyImageAttributeRequest.getOperationType()));
        }
        if (modifyImageAttributeRequest != null) {
            List<String> userIdsList = modifyImageAttributeRequest.getUserIds();
            int userIdsListIndex = 1;
            for (String userIdsListValue : userIdsList) {
                if (userIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString(userIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (modifyImageAttributeRequest != null) {
            List<String> userGroupsList = modifyImageAttributeRequest.getUserGroups();
            int userGroupsListIndex = 1;
            for (String userGroupsListValue : userGroupsList) {
                if (userGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString(userGroupsListValue));
                }
                ++userGroupsListIndex;
            }
        }
        if (modifyImageAttributeRequest != null) {
            List<String> productCodesList = modifyImageAttributeRequest.getProductCodes();
            int productCodesListIndex = 1;
            for (String productCodesListValue : productCodesList) {
                if (productCodesListValue != null) {
                    request.addParameter("ProductCode." + productCodesListIndex, StringUtils.fromString(productCodesListValue));
                }
                ++productCodesListIndex;
            }
        }
        if (modifyImageAttributeRequest != null && modifyImageAttributeRequest.getValue() != null) {
            request.addParameter("Value", StringUtils.fromString(modifyImageAttributeRequest.getValue()));
        }
        return request;
    }
}

