/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.transform.UserIdGroupPairUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpPermissionUnmarshaller
implements Unmarshaller<IpPermission, Node> {
    @Override
    public IpPermission unmarshall(Node node) throws Exception {
        IpPermission ipPermission = new IpPermission();
        Node ipProtocolNode = XpathUtils.asNode("ipProtocol", node);
        ipPermission.setIpProtocol(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ipProtocolNode));
        Node fromPortNode = XpathUtils.asNode("fromPort", node);
        ipPermission.setFromPort(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(fromPortNode));
        Node toPortNode = XpathUtils.asNode("toPort", node);
        ipPermission.setToPort(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(toPortNode));
        NodeList userIdGroupPairsNodes = XpathUtils.asNodeList("groups/item", node);
        for (int userIdGroupPairsIndex = 0; userIdGroupPairsIndex < XpathUtils.nodeLength(userIdGroupPairsNodes); ++userIdGroupPairsIndex) {
            Node userIdGroupPairsNode = userIdGroupPairsNodes.item(userIdGroupPairsIndex);
            ipPermission.getUserIdGroupPairs().add(new UserIdGroupPairUnmarshaller().unmarshall(userIdGroupPairsNode));
            userIdGroupPairsNode.getParentNode().removeChild(userIdGroupPairsNode);
        }
        NodeList ipRangesNodes = XpathUtils.asNodeList("ipRanges/item/cidrIp", node);
        for (int ipRangesIndex = 0; ipRangesIndex < XpathUtils.nodeLength(ipRangesNodes); ++ipRangesIndex) {
            Node ipRangesNode = ipRangesNodes.item(ipRangesIndex);
            ipPermission.getIpRanges().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ipRangesNode));
            ipRangesNode.getParentNode().removeChild(ipRangesNode);
        }
        return ipPermission;
    }
}

