/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeVolumesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeVolumesRequestMarshaller
implements Marshaller<Request<DescribeVolumesRequest>, DescribeVolumesRequest> {
    @Override
    public Request<DescribeVolumesRequest> marshall(DescribeVolumesRequest describeVolumesRequest) {
        DefaultRequest<DescribeVolumesRequest> request = new DefaultRequest<DescribeVolumesRequest>(describeVolumesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVolumes");
        request.addParameter("Version", "2009-10-31");
        if (describeVolumesRequest != null) {
            List<String> volumeIdsList = describeVolumesRequest.getVolumeIds();
            int volumeIdsListIndex = 1;
            for (String volumeIdsListValue : volumeIdsList) {
                if (volumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringUtils.fromString(volumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        return request;
    }
}

