/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.xray.model.ErrorStatistics;

@SdkInternalApi
public class ErrorStatisticsMarshaller {
    private static final MarshallingInfo<Long> THROTTLECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThrottleCount").build();
    private static final MarshallingInfo<Long> OTHERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OtherCount").build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").build();
    private static final ErrorStatisticsMarshaller instance = new ErrorStatisticsMarshaller();

    public static ErrorStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ErrorStatistics errorStatistics, ProtocolMarshaller protocolMarshaller) {
        if (errorStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)errorStatistics.getThrottleCount(), THROTTLECOUNT_BINDING);
            protocolMarshaller.marshall((Object)errorStatistics.getOtherCount(), OTHERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)errorStatistics.getTotalCount(), TOTALCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

