/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.xray.AWSXRay;
import com.amazonaws.services.xray.AWSXRayClientBuilder;
import com.amazonaws.services.xray.model.AWSXRayException;
import com.amazonaws.services.xray.model.BatchGetTracesRequest;
import com.amazonaws.services.xray.model.BatchGetTracesResult;
import com.amazonaws.services.xray.model.CreateGroupRequest;
import com.amazonaws.services.xray.model.CreateGroupResult;
import com.amazonaws.services.xray.model.CreateSamplingRuleRequest;
import com.amazonaws.services.xray.model.CreateSamplingRuleResult;
import com.amazonaws.services.xray.model.DeleteGroupRequest;
import com.amazonaws.services.xray.model.DeleteGroupResult;
import com.amazonaws.services.xray.model.DeleteResourcePolicyRequest;
import com.amazonaws.services.xray.model.DeleteResourcePolicyResult;
import com.amazonaws.services.xray.model.DeleteSamplingRuleRequest;
import com.amazonaws.services.xray.model.DeleteSamplingRuleResult;
import com.amazonaws.services.xray.model.GetEncryptionConfigRequest;
import com.amazonaws.services.xray.model.GetEncryptionConfigResult;
import com.amazonaws.services.xray.model.GetGroupRequest;
import com.amazonaws.services.xray.model.GetGroupResult;
import com.amazonaws.services.xray.model.GetGroupsRequest;
import com.amazonaws.services.xray.model.GetGroupsResult;
import com.amazonaws.services.xray.model.GetInsightEventsRequest;
import com.amazonaws.services.xray.model.GetInsightEventsResult;
import com.amazonaws.services.xray.model.GetInsightImpactGraphRequest;
import com.amazonaws.services.xray.model.GetInsightImpactGraphResult;
import com.amazonaws.services.xray.model.GetInsightRequest;
import com.amazonaws.services.xray.model.GetInsightResult;
import com.amazonaws.services.xray.model.GetInsightSummariesRequest;
import com.amazonaws.services.xray.model.GetInsightSummariesResult;
import com.amazonaws.services.xray.model.GetSamplingRulesRequest;
import com.amazonaws.services.xray.model.GetSamplingRulesResult;
import com.amazonaws.services.xray.model.GetSamplingStatisticSummariesRequest;
import com.amazonaws.services.xray.model.GetSamplingStatisticSummariesResult;
import com.amazonaws.services.xray.model.GetSamplingTargetsRequest;
import com.amazonaws.services.xray.model.GetSamplingTargetsResult;
import com.amazonaws.services.xray.model.GetServiceGraphRequest;
import com.amazonaws.services.xray.model.GetServiceGraphResult;
import com.amazonaws.services.xray.model.GetTimeSeriesServiceStatisticsRequest;
import com.amazonaws.services.xray.model.GetTimeSeriesServiceStatisticsResult;
import com.amazonaws.services.xray.model.GetTraceGraphRequest;
import com.amazonaws.services.xray.model.GetTraceGraphResult;
import com.amazonaws.services.xray.model.GetTraceSummariesRequest;
import com.amazonaws.services.xray.model.GetTraceSummariesResult;
import com.amazonaws.services.xray.model.ListResourcePoliciesRequest;
import com.amazonaws.services.xray.model.ListResourcePoliciesResult;
import com.amazonaws.services.xray.model.ListTagsForResourceRequest;
import com.amazonaws.services.xray.model.ListTagsForResourceResult;
import com.amazonaws.services.xray.model.PutEncryptionConfigRequest;
import com.amazonaws.services.xray.model.PutEncryptionConfigResult;
import com.amazonaws.services.xray.model.PutResourcePolicyRequest;
import com.amazonaws.services.xray.model.PutResourcePolicyResult;
import com.amazonaws.services.xray.model.PutTelemetryRecordsRequest;
import com.amazonaws.services.xray.model.PutTelemetryRecordsResult;
import com.amazonaws.services.xray.model.PutTraceSegmentsRequest;
import com.amazonaws.services.xray.model.PutTraceSegmentsResult;
import com.amazonaws.services.xray.model.TagResourceRequest;
import com.amazonaws.services.xray.model.TagResourceResult;
import com.amazonaws.services.xray.model.UntagResourceRequest;
import com.amazonaws.services.xray.model.UntagResourceResult;
import com.amazonaws.services.xray.model.UpdateGroupRequest;
import com.amazonaws.services.xray.model.UpdateGroupResult;
import com.amazonaws.services.xray.model.UpdateSamplingRuleRequest;
import com.amazonaws.services.xray.model.UpdateSamplingRuleResult;
import com.amazonaws.services.xray.model.transform.BatchGetTracesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.BatchGetTracesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.CreateGroupRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.CreateGroupResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.CreateSamplingRuleRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.CreateSamplingRuleResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.DeleteGroupRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.DeleteGroupResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.DeleteResourcePolicyRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.DeleteResourcePolicyResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.DeleteSamplingRuleRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.DeleteSamplingRuleResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetEncryptionConfigRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetEncryptionConfigResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetGroupRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetGroupResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetGroupsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetGroupsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetInsightEventsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetInsightEventsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetInsightImpactGraphRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetInsightImpactGraphResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetInsightRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetInsightResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetInsightSummariesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetInsightSummariesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingRulesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingRulesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingStatisticSummariesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingStatisticSummariesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingTargetsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingTargetsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetServiceGraphRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetServiceGraphResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetTimeSeriesServiceStatisticsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetTimeSeriesServiceStatisticsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceGraphRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceGraphResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceSummariesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceSummariesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.InvalidPolicyRevisionIdExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.ListResourcePoliciesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.ListResourcePoliciesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.LockoutPreventionExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.PolicyCountLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.PolicySizeLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutEncryptionConfigRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutEncryptionConfigResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutResourcePolicyRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutResourcePolicyResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutTelemetryRecordsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutTelemetryRecordsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutTraceSegmentsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutTraceSegmentsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.RuleLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.ThrottledExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.TooManyTagsExceptionUnmarshaller;
import com.amazonaws.services.xray.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.UpdateGroupRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.UpdateGroupResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.UpdateSamplingRuleRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.UpdateSamplingRuleResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSXRayClient
extends AmazonWebServiceClient
implements AWSXRay {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSXRay.class);
    private static final String DEFAULT_SIGNING_NAME = "xray";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MalformedPolicyDocumentException").withExceptionUnmarshaller((JsonErrorUnmarshaller)MalformedPolicyDocumentExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPolicyRevisionIdException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidPolicyRevisionIdExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottledException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottledExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RuleLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RuleLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyTagsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyCountLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)PolicyCountLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LockoutPreventionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LockoutPreventionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicySizeLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)PolicySizeLimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSXRayException.class));

    @Deprecated
    public AWSXRayClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSXRayClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSXRayClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSXRayClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AWSXRayClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSXRayClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSXRayClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AWSXRayClientBuilder builder() {
        return AWSXRayClientBuilder.standard();
    }

    AWSXRayClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSXRayClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("xray.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/xray/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/xray/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchGetTracesResult batchGetTraces(BatchGetTracesRequest request) {
        request = (BatchGetTracesRequest)this.beforeClientExecution(request);
        return this.executeBatchGetTraces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetTracesResult executeBatchGetTraces(BatchGetTracesRequest batchGetTracesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetTracesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetTracesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetTracesRequestProtocolMarshaller(protocolFactory).marshall((BatchGetTracesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetTracesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetTraces");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetTracesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetTracesResult batchGetTracesResult = (BatchGetTracesResult)response.getAwsResponse();
            return batchGetTracesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateGroupResult createGroup(CreateGroupRequest request) {
        request = (CreateGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateGroupResult executeCreateGroup(CreateGroupRequest createGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateGroupResult createGroupResult = (CreateGroupResult)response.getAwsResponse();
            return createGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSamplingRuleResult createSamplingRule(CreateSamplingRuleRequest request) {
        request = (CreateSamplingRuleRequest)this.beforeClientExecution(request);
        return this.executeCreateSamplingRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSamplingRuleResult executeCreateSamplingRule(CreateSamplingRuleRequest createSamplingRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSamplingRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSamplingRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSamplingRuleRequestProtocolMarshaller(protocolFactory).marshall((CreateSamplingRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSamplingRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSamplingRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSamplingRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSamplingRuleResult createSamplingRuleResult = (CreateSamplingRuleResult)response.getAwsResponse();
            return createSamplingRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteGroupResult deleteGroup(DeleteGroupRequest request) {
        request = (DeleteGroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteGroupResult executeDeleteGroup(DeleteGroupRequest deleteGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteGroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteGroupResult deleteGroupResult = (DeleteGroupResult)response.getAwsResponse();
            return deleteGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        request = (DeleteResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteResourcePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResourcePolicyResult executeDeleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResourcePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResourcePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResourcePolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteResourcePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteResourcePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteResourcePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteResourcePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResourcePolicyResult deleteResourcePolicyResult = (DeleteResourcePolicyResult)response.getAwsResponse();
            return deleteResourcePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSamplingRuleResult deleteSamplingRule(DeleteSamplingRuleRequest request) {
        request = (DeleteSamplingRuleRequest)this.beforeClientExecution(request);
        return this.executeDeleteSamplingRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSamplingRuleResult executeDeleteSamplingRule(DeleteSamplingRuleRequest deleteSamplingRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSamplingRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSamplingRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSamplingRuleRequestProtocolMarshaller(protocolFactory).marshall((DeleteSamplingRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSamplingRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSamplingRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSamplingRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSamplingRuleResult deleteSamplingRuleResult = (DeleteSamplingRuleResult)response.getAwsResponse();
            return deleteSamplingRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEncryptionConfigResult getEncryptionConfig(GetEncryptionConfigRequest request) {
        request = (GetEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executeGetEncryptionConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEncryptionConfigResult executeGetEncryptionConfig(GetEncryptionConfigRequest getEncryptionConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEncryptionConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEncryptionConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEncryptionConfigRequestProtocolMarshaller(protocolFactory).marshall((GetEncryptionConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEncryptionConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEncryptionConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEncryptionConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEncryptionConfigResult getEncryptionConfigResult = (GetEncryptionConfigResult)response.getAwsResponse();
            return getEncryptionConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetGroupResult getGroup(GetGroupRequest request) {
        request = (GetGroupRequest)this.beforeClientExecution(request);
        return this.executeGetGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetGroupResult executeGetGroup(GetGroupRequest getGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetGroupRequestProtocolMarshaller(protocolFactory).marshall((GetGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)getGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetGroupResult getGroupResult = (GetGroupResult)response.getAwsResponse();
            return getGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetGroupsResult getGroups(GetGroupsRequest request) {
        request = (GetGroupsRequest)this.beforeClientExecution(request);
        return this.executeGetGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetGroupsResult executeGetGroups(GetGroupsRequest getGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetGroupsRequestProtocolMarshaller(protocolFactory).marshall((GetGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetGroupsResult getGroupsResult = (GetGroupsResult)response.getAwsResponse();
            return getGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInsightResult getInsight(GetInsightRequest request) {
        request = (GetInsightRequest)this.beforeClientExecution(request);
        return this.executeGetInsight(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInsightResult executeGetInsight(GetInsightRequest getInsightRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInsightRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInsightRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInsightRequestProtocolMarshaller(protocolFactory).marshall((GetInsightRequest)super.beforeMarshalling((AmazonWebServiceRequest)getInsightRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetInsight");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInsightResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInsightResult getInsightResult = (GetInsightResult)response.getAwsResponse();
            return getInsightResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInsightEventsResult getInsightEvents(GetInsightEventsRequest request) {
        request = (GetInsightEventsRequest)this.beforeClientExecution(request);
        return this.executeGetInsightEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInsightEventsResult executeGetInsightEvents(GetInsightEventsRequest getInsightEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInsightEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInsightEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInsightEventsRequestProtocolMarshaller(protocolFactory).marshall((GetInsightEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getInsightEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetInsightEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInsightEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInsightEventsResult getInsightEventsResult = (GetInsightEventsResult)response.getAwsResponse();
            return getInsightEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInsightImpactGraphResult getInsightImpactGraph(GetInsightImpactGraphRequest request) {
        request = (GetInsightImpactGraphRequest)this.beforeClientExecution(request);
        return this.executeGetInsightImpactGraph(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInsightImpactGraphResult executeGetInsightImpactGraph(GetInsightImpactGraphRequest getInsightImpactGraphRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInsightImpactGraphRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInsightImpactGraphRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInsightImpactGraphRequestProtocolMarshaller(protocolFactory).marshall((GetInsightImpactGraphRequest)super.beforeMarshalling((AmazonWebServiceRequest)getInsightImpactGraphRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetInsightImpactGraph");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInsightImpactGraphResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInsightImpactGraphResult getInsightImpactGraphResult = (GetInsightImpactGraphResult)response.getAwsResponse();
            return getInsightImpactGraphResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInsightSummariesResult getInsightSummaries(GetInsightSummariesRequest request) {
        request = (GetInsightSummariesRequest)this.beforeClientExecution(request);
        return this.executeGetInsightSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInsightSummariesResult executeGetInsightSummaries(GetInsightSummariesRequest getInsightSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInsightSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInsightSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInsightSummariesRequestProtocolMarshaller(protocolFactory).marshall((GetInsightSummariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getInsightSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetInsightSummaries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInsightSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInsightSummariesResult getInsightSummariesResult = (GetInsightSummariesResult)response.getAwsResponse();
            return getInsightSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSamplingRulesResult getSamplingRules(GetSamplingRulesRequest request) {
        request = (GetSamplingRulesRequest)this.beforeClientExecution(request);
        return this.executeGetSamplingRules(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSamplingRulesResult executeGetSamplingRules(GetSamplingRulesRequest getSamplingRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSamplingRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSamplingRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSamplingRulesRequestProtocolMarshaller(protocolFactory).marshall((GetSamplingRulesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSamplingRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSamplingRules");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSamplingRulesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSamplingRulesResult getSamplingRulesResult = (GetSamplingRulesResult)response.getAwsResponse();
            return getSamplingRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSamplingStatisticSummariesResult getSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest request) {
        request = (GetSamplingStatisticSummariesRequest)this.beforeClientExecution(request);
        return this.executeGetSamplingStatisticSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSamplingStatisticSummariesResult executeGetSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest getSamplingStatisticSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSamplingStatisticSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSamplingStatisticSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSamplingStatisticSummariesRequestProtocolMarshaller(protocolFactory).marshall((GetSamplingStatisticSummariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSamplingStatisticSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSamplingStatisticSummaries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSamplingStatisticSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSamplingStatisticSummariesResult getSamplingStatisticSummariesResult = (GetSamplingStatisticSummariesResult)response.getAwsResponse();
            return getSamplingStatisticSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSamplingTargetsResult getSamplingTargets(GetSamplingTargetsRequest request) {
        request = (GetSamplingTargetsRequest)this.beforeClientExecution(request);
        return this.executeGetSamplingTargets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSamplingTargetsResult executeGetSamplingTargets(GetSamplingTargetsRequest getSamplingTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSamplingTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSamplingTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSamplingTargetsRequestProtocolMarshaller(protocolFactory).marshall((GetSamplingTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSamplingTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSamplingTargets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSamplingTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSamplingTargetsResult getSamplingTargetsResult = (GetSamplingTargetsResult)response.getAwsResponse();
            return getSamplingTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetServiceGraphResult getServiceGraph(GetServiceGraphRequest request) {
        request = (GetServiceGraphRequest)this.beforeClientExecution(request);
        return this.executeGetServiceGraph(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetServiceGraphResult executeGetServiceGraph(GetServiceGraphRequest getServiceGraphRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getServiceGraphRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetServiceGraphRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetServiceGraphRequestProtocolMarshaller(protocolFactory).marshall((GetServiceGraphRequest)super.beforeMarshalling((AmazonWebServiceRequest)getServiceGraphRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetServiceGraph");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServiceGraphResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetServiceGraphResult getServiceGraphResult = (GetServiceGraphResult)response.getAwsResponse();
            return getServiceGraphResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTimeSeriesServiceStatisticsResult getTimeSeriesServiceStatistics(GetTimeSeriesServiceStatisticsRequest request) {
        request = (GetTimeSeriesServiceStatisticsRequest)this.beforeClientExecution(request);
        return this.executeGetTimeSeriesServiceStatistics(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTimeSeriesServiceStatisticsResult executeGetTimeSeriesServiceStatistics(GetTimeSeriesServiceStatisticsRequest getTimeSeriesServiceStatisticsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTimeSeriesServiceStatisticsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTimeSeriesServiceStatisticsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTimeSeriesServiceStatisticsRequestProtocolMarshaller(protocolFactory).marshall((GetTimeSeriesServiceStatisticsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTimeSeriesServiceStatisticsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTimeSeriesServiceStatistics");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTimeSeriesServiceStatisticsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTimeSeriesServiceStatisticsResult getTimeSeriesServiceStatisticsResult = (GetTimeSeriesServiceStatisticsResult)response.getAwsResponse();
            return getTimeSeriesServiceStatisticsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTraceGraphResult getTraceGraph(GetTraceGraphRequest request) {
        request = (GetTraceGraphRequest)this.beforeClientExecution(request);
        return this.executeGetTraceGraph(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTraceGraphResult executeGetTraceGraph(GetTraceGraphRequest getTraceGraphRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTraceGraphRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTraceGraphRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTraceGraphRequestProtocolMarshaller(protocolFactory).marshall((GetTraceGraphRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTraceGraphRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTraceGraph");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTraceGraphResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTraceGraphResult getTraceGraphResult = (GetTraceGraphResult)response.getAwsResponse();
            return getTraceGraphResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTraceSummariesResult getTraceSummaries(GetTraceSummariesRequest request) {
        request = (GetTraceSummariesRequest)this.beforeClientExecution(request);
        return this.executeGetTraceSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTraceSummariesResult executeGetTraceSummaries(GetTraceSummariesRequest getTraceSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTraceSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTraceSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTraceSummariesRequestProtocolMarshaller(protocolFactory).marshall((GetTraceSummariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTraceSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTraceSummaries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTraceSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTraceSummariesResult getTraceSummariesResult = (GetTraceSummariesResult)response.getAwsResponse();
            return getTraceSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResourcePoliciesResult listResourcePolicies(ListResourcePoliciesRequest request) {
        request = (ListResourcePoliciesRequest)this.beforeClientExecution(request);
        return this.executeListResourcePolicies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResourcePoliciesResult executeListResourcePolicies(ListResourcePoliciesRequest listResourcePoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResourcePoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResourcePoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResourcePoliciesRequestProtocolMarshaller(protocolFactory).marshall((ListResourcePoliciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listResourcePoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListResourcePolicies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResourcePoliciesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResourcePoliciesResult listResourcePoliciesResult = (ListResourcePoliciesResult)response.getAwsResponse();
            return listResourcePoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutEncryptionConfigResult putEncryptionConfig(PutEncryptionConfigRequest request) {
        request = (PutEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executePutEncryptionConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutEncryptionConfigResult executePutEncryptionConfig(PutEncryptionConfigRequest putEncryptionConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEncryptionConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEncryptionConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEncryptionConfigRequestProtocolMarshaller(protocolFactory).marshall((PutEncryptionConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)putEncryptionConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutEncryptionConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutEncryptionConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutEncryptionConfigResult putEncryptionConfigResult = (PutEncryptionConfigResult)response.getAwsResponse();
            return putEncryptionConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        request = (PutResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executePutResourcePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutResourcePolicyResult executePutResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putResourcePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutResourcePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutResourcePolicyRequestProtocolMarshaller(protocolFactory).marshall((PutResourcePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putResourcePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutResourcePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutResourcePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutResourcePolicyResult putResourcePolicyResult = (PutResourcePolicyResult)response.getAwsResponse();
            return putResourcePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutTelemetryRecordsResult putTelemetryRecords(PutTelemetryRecordsRequest request) {
        request = (PutTelemetryRecordsRequest)this.beforeClientExecution(request);
        return this.executePutTelemetryRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutTelemetryRecordsResult executePutTelemetryRecords(PutTelemetryRecordsRequest putTelemetryRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putTelemetryRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutTelemetryRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutTelemetryRecordsRequestProtocolMarshaller(protocolFactory).marshall((PutTelemetryRecordsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putTelemetryRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutTelemetryRecords");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTelemetryRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutTelemetryRecordsResult putTelemetryRecordsResult = (PutTelemetryRecordsResult)response.getAwsResponse();
            return putTelemetryRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutTraceSegmentsResult putTraceSegments(PutTraceSegmentsRequest request) {
        request = (PutTraceSegmentsRequest)this.beforeClientExecution(request);
        return this.executePutTraceSegments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutTraceSegmentsResult executePutTraceSegments(PutTraceSegmentsRequest putTraceSegmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putTraceSegmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutTraceSegmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutTraceSegmentsRequestProtocolMarshaller(protocolFactory).marshall((PutTraceSegmentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putTraceSegmentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutTraceSegments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTraceSegmentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutTraceSegmentsResult putTraceSegmentsResult = (PutTraceSegmentsResult)response.getAwsResponse();
            return putTraceSegmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateGroupResult updateGroup(UpdateGroupRequest request) {
        request = (UpdateGroupRequest)this.beforeClientExecution(request);
        return this.executeUpdateGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateGroupResult executeUpdateGroup(UpdateGroupRequest updateGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateGroupRequestProtocolMarshaller(protocolFactory).marshall((UpdateGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateGroupResult updateGroupResult = (UpdateGroupResult)response.getAwsResponse();
            return updateGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSamplingRuleResult updateSamplingRule(UpdateSamplingRuleRequest request) {
        request = (UpdateSamplingRuleRequest)this.beforeClientExecution(request);
        return this.executeUpdateSamplingRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSamplingRuleResult executeUpdateSamplingRule(UpdateSamplingRuleRequest updateSamplingRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSamplingRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSamplingRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSamplingRuleRequestProtocolMarshaller(protocolFactory).marshall((UpdateSamplingRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSamplingRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSamplingRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSamplingRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSamplingRuleResult updateSamplingRuleResult = (UpdateSamplingRuleResult)response.getAwsResponse();
            return updateSamplingRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

