/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.xray.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateGroup" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateGroupRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The case-sensitive name of the group.
     * </p>
     */
    private String groupName;
    /**
     * <p>
     * The ARN that was generated upon creation.
     * </p>
     */
    private String groupARN;
    /**
     * <p>
     * The updated filter expression defining criteria by which to group traces.
     * </p>
     */
    private String filterExpression;
    /**
     * <p>
     * The structure containing configurations related to insights.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for
     * the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The NotificationsEnabled boolean can be set to true to enable insights notifications for the group. Notifications
     * can only be enabled on a group with InsightsEnabled set to true.
     * </p>
     * </li>
     * </ul>
     */
    private InsightsConfiguration insightsConfiguration;

    /**
     * <p>
     * The case-sensitive name of the group.
     * </p>
     * 
     * @param groupName
     *        The case-sensitive name of the group.
     */

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    /**
     * <p>
     * The case-sensitive name of the group.
     * </p>
     * 
     * @return The case-sensitive name of the group.
     */

    public String getGroupName() {
        return this.groupName;
    }

    /**
     * <p>
     * The case-sensitive name of the group.
     * </p>
     * 
     * @param groupName
     *        The case-sensitive name of the group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateGroupRequest withGroupName(String groupName) {
        setGroupName(groupName);
        return this;
    }

    /**
     * <p>
     * The ARN that was generated upon creation.
     * </p>
     * 
     * @param groupARN
     *        The ARN that was generated upon creation.
     */

    public void setGroupARN(String groupARN) {
        this.groupARN = groupARN;
    }

    /**
     * <p>
     * The ARN that was generated upon creation.
     * </p>
     * 
     * @return The ARN that was generated upon creation.
     */

    public String getGroupARN() {
        return this.groupARN;
    }

    /**
     * <p>
     * The ARN that was generated upon creation.
     * </p>
     * 
     * @param groupARN
     *        The ARN that was generated upon creation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateGroupRequest withGroupARN(String groupARN) {
        setGroupARN(groupARN);
        return this;
    }

    /**
     * <p>
     * The updated filter expression defining criteria by which to group traces.
     * </p>
     * 
     * @param filterExpression
     *        The updated filter expression defining criteria by which to group traces.
     */

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    /**
     * <p>
     * The updated filter expression defining criteria by which to group traces.
     * </p>
     * 
     * @return The updated filter expression defining criteria by which to group traces.
     */

    public String getFilterExpression() {
        return this.filterExpression;
    }

    /**
     * <p>
     * The updated filter expression defining criteria by which to group traces.
     * </p>
     * 
     * @param filterExpression
     *        The updated filter expression defining criteria by which to group traces.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateGroupRequest withFilterExpression(String filterExpression) {
        setFilterExpression(filterExpression);
        return this;
    }

    /**
     * <p>
     * The structure containing configurations related to insights.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for
     * the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The NotificationsEnabled boolean can be set to true to enable insights notifications for the group. Notifications
     * can only be enabled on a group with InsightsEnabled set to true.
     * </p>
     * </li>
     * </ul>
     * 
     * @param insightsConfiguration
     *        The structure containing configurations related to insights.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable
     *        insights for the group.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The NotificationsEnabled boolean can be set to true to enable insights notifications for the group.
     *        Notifications can only be enabled on a group with InsightsEnabled set to true.
     *        </p>
     *        </li>
     */

    public void setInsightsConfiguration(InsightsConfiguration insightsConfiguration) {
        this.insightsConfiguration = insightsConfiguration;
    }

    /**
     * <p>
     * The structure containing configurations related to insights.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for
     * the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The NotificationsEnabled boolean can be set to true to enable insights notifications for the group. Notifications
     * can only be enabled on a group with InsightsEnabled set to true.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The structure containing configurations related to insights.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable
     *         insights for the group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The NotificationsEnabled boolean can be set to true to enable insights notifications for the group.
     *         Notifications can only be enabled on a group with InsightsEnabled set to true.
     *         </p>
     *         </li>
     */

    public InsightsConfiguration getInsightsConfiguration() {
        return this.insightsConfiguration;
    }

    /**
     * <p>
     * The structure containing configurations related to insights.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for
     * the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The NotificationsEnabled boolean can be set to true to enable insights notifications for the group. Notifications
     * can only be enabled on a group with InsightsEnabled set to true.
     * </p>
     * </li>
     * </ul>
     * 
     * @param insightsConfiguration
     *        The structure containing configurations related to insights.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable
     *        insights for the group.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The NotificationsEnabled boolean can be set to true to enable insights notifications for the group.
     *        Notifications can only be enabled on a group with InsightsEnabled set to true.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateGroupRequest withInsightsConfiguration(InsightsConfiguration insightsConfiguration) {
        setInsightsConfiguration(insightsConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGroupName() != null)
            sb.append("GroupName: ").append(getGroupName()).append(",");
        if (getGroupARN() != null)
            sb.append("GroupARN: ").append(getGroupARN()).append(",");
        if (getFilterExpression() != null)
            sb.append("FilterExpression: ").append(getFilterExpression()).append(",");
        if (getInsightsConfiguration() != null)
            sb.append("InsightsConfiguration: ").append(getInsightsConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateGroupRequest == false)
            return false;
        UpdateGroupRequest other = (UpdateGroupRequest) obj;
        if (other.getGroupName() == null ^ this.getGroupName() == null)
            return false;
        if (other.getGroupName() != null && other.getGroupName().equals(this.getGroupName()) == false)
            return false;
        if (other.getGroupARN() == null ^ this.getGroupARN() == null)
            return false;
        if (other.getGroupARN() != null && other.getGroupARN().equals(this.getGroupARN()) == false)
            return false;
        if (other.getFilterExpression() == null ^ this.getFilterExpression() == null)
            return false;
        if (other.getFilterExpression() != null && other.getFilterExpression().equals(this.getFilterExpression()) == false)
            return false;
        if (other.getInsightsConfiguration() == null ^ this.getInsightsConfiguration() == null)
            return false;
        if (other.getInsightsConfiguration() != null && other.getInsightsConfiguration().equals(this.getInsightsConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGroupName() == null) ? 0 : getGroupName().hashCode());
        hashCode = prime * hashCode + ((getGroupARN() == null) ? 0 : getGroupARN().hashCode());
        hashCode = prime * hashCode + ((getFilterExpression() == null) ? 0 : getFilterExpression().hashCode());
        hashCode = prime * hashCode + ((getInsightsConfiguration() == null) ? 0 : getInsightsConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public UpdateGroupRequest clone() {
        return (UpdateGroupRequest) super.clone();
    }

}
