/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.Alias;
import com.amazonaws.services.xray.model.Edge;
import com.amazonaws.services.xray.model.HistogramEntry;
import com.amazonaws.services.xray.model.transform.AliasJsonMarshaller;
import com.amazonaws.services.xray.model.transform.EdgeStatisticsJsonMarshaller;
import com.amazonaws.services.xray.model.transform.HistogramEntryJsonMarshaller;
import java.util.List;

public class EdgeJsonMarshaller {
    private static EdgeJsonMarshaller instance;

    public void marshall(Edge edge, StructuredJsonGenerator jsonGenerator) {
        if (edge == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Alias> aliasesList;
            List<HistogramEntry> responseTimeHistogramList;
            jsonGenerator.writeStartObject();
            if (edge.getReferenceId() != null) {
                jsonGenerator.writeFieldName("ReferenceId").writeValue(edge.getReferenceId().intValue());
            }
            if (edge.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(edge.getStartTime());
            }
            if (edge.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(edge.getEndTime());
            }
            if (edge.getSummaryStatistics() != null) {
                jsonGenerator.writeFieldName("SummaryStatistics");
                EdgeStatisticsJsonMarshaller.getInstance().marshall(edge.getSummaryStatistics(), jsonGenerator);
            }
            if ((responseTimeHistogramList = edge.getResponseTimeHistogram()) != null) {
                jsonGenerator.writeFieldName("ResponseTimeHistogram");
                jsonGenerator.writeStartArray();
                for (HistogramEntry responseTimeHistogramListValue : responseTimeHistogramList) {
                    if (responseTimeHistogramListValue == null) continue;
                    HistogramEntryJsonMarshaller.getInstance().marshall(responseTimeHistogramListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((aliasesList = edge.getAliases()) != null) {
                jsonGenerator.writeFieldName("Aliases");
                jsonGenerator.writeStartArray();
                for (Alias aliasesListValue : aliasesList) {
                    if (aliasesListValue == null) continue;
                    AliasJsonMarshaller.getInstance().marshall(aliasesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EdgeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EdgeJsonMarshaller();
        }
        return instance;
    }
}

