/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.xray.AWSXRay;
import com.amazonaws.services.xray.AWSXRayClientBuilder;
import com.amazonaws.services.xray.model.AWSXRayException;
import com.amazonaws.services.xray.model.BatchGetTracesRequest;
import com.amazonaws.services.xray.model.BatchGetTracesResult;
import com.amazonaws.services.xray.model.CreateSamplingRuleRequest;
import com.amazonaws.services.xray.model.CreateSamplingRuleResult;
import com.amazonaws.services.xray.model.DeleteSamplingRuleRequest;
import com.amazonaws.services.xray.model.DeleteSamplingRuleResult;
import com.amazonaws.services.xray.model.GetEncryptionConfigRequest;
import com.amazonaws.services.xray.model.GetEncryptionConfigResult;
import com.amazonaws.services.xray.model.GetSamplingRulesRequest;
import com.amazonaws.services.xray.model.GetSamplingRulesResult;
import com.amazonaws.services.xray.model.GetSamplingStatisticSummariesRequest;
import com.amazonaws.services.xray.model.GetSamplingStatisticSummariesResult;
import com.amazonaws.services.xray.model.GetSamplingTargetsRequest;
import com.amazonaws.services.xray.model.GetSamplingTargetsResult;
import com.amazonaws.services.xray.model.GetServiceGraphRequest;
import com.amazonaws.services.xray.model.GetServiceGraphResult;
import com.amazonaws.services.xray.model.GetTraceGraphRequest;
import com.amazonaws.services.xray.model.GetTraceGraphResult;
import com.amazonaws.services.xray.model.GetTraceSummariesRequest;
import com.amazonaws.services.xray.model.GetTraceSummariesResult;
import com.amazonaws.services.xray.model.InvalidRequestException;
import com.amazonaws.services.xray.model.PutEncryptionConfigRequest;
import com.amazonaws.services.xray.model.PutEncryptionConfigResult;
import com.amazonaws.services.xray.model.PutTelemetryRecordsRequest;
import com.amazonaws.services.xray.model.PutTelemetryRecordsResult;
import com.amazonaws.services.xray.model.PutTraceSegmentsRequest;
import com.amazonaws.services.xray.model.PutTraceSegmentsResult;
import com.amazonaws.services.xray.model.RuleLimitExceededException;
import com.amazonaws.services.xray.model.ThrottledException;
import com.amazonaws.services.xray.model.UpdateSamplingRuleRequest;
import com.amazonaws.services.xray.model.UpdateSamplingRuleResult;
import com.amazonaws.services.xray.model.transform.BatchGetTracesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.BatchGetTracesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.CreateSamplingRuleRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.CreateSamplingRuleResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.DeleteSamplingRuleRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.DeleteSamplingRuleResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetEncryptionConfigRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetEncryptionConfigResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingRulesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingRulesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingStatisticSummariesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingStatisticSummariesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingTargetsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetSamplingTargetsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetServiceGraphRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetServiceGraphResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceGraphRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceGraphResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceSummariesRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.GetTraceSummariesResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutEncryptionConfigRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutEncryptionConfigResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutTelemetryRecordsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutTelemetryRecordsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.PutTraceSegmentsRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.PutTraceSegmentsResultJsonUnmarshaller;
import com.amazonaws.services.xray.model.transform.UpdateSamplingRuleRequestProtocolMarshaller;
import com.amazonaws.services.xray.model.transform.UpdateSamplingRuleResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSXRayClient
extends AmazonWebServiceClient
implements AWSXRay {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSXRay.class);
    private static final String DEFAULT_SIGNING_NAME = "xray";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottledException").withModeledClass(ThrottledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RuleLimitExceededException").withModeledClass(RuleLimitExceededException.class)).withBaseServiceExceptionClass(AWSXRayException.class));

    @Deprecated
    public AWSXRayClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSXRayClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSXRayClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSXRayClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSXRayClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSXRayClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSXRayClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSXRayClientBuilder builder() {
        return AWSXRayClientBuilder.standard();
    }

    AWSXRayClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    AWSXRayClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("xray.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/xray/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/xray/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchGetTracesResult batchGetTraces(BatchGetTracesRequest request) {
        request = (BatchGetTracesRequest)this.beforeClientExecution(request);
        return this.executeBatchGetTraces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetTracesResult executeBatchGetTraces(BatchGetTracesRequest batchGetTracesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetTracesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetTracesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetTracesRequestProtocolMarshaller(protocolFactory).marshall((BatchGetTracesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetTracesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetTraces");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetTracesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetTracesResult batchGetTracesResult = (BatchGetTracesResult)response.getAwsResponse();
            return batchGetTracesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSamplingRuleResult createSamplingRule(CreateSamplingRuleRequest request) {
        request = (CreateSamplingRuleRequest)this.beforeClientExecution(request);
        return this.executeCreateSamplingRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSamplingRuleResult executeCreateSamplingRule(CreateSamplingRuleRequest createSamplingRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSamplingRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSamplingRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSamplingRuleRequestProtocolMarshaller(protocolFactory).marshall((CreateSamplingRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSamplingRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSamplingRule");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSamplingRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSamplingRuleResult createSamplingRuleResult = (CreateSamplingRuleResult)response.getAwsResponse();
            return createSamplingRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSamplingRuleResult deleteSamplingRule(DeleteSamplingRuleRequest request) {
        request = (DeleteSamplingRuleRequest)this.beforeClientExecution(request);
        return this.executeDeleteSamplingRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSamplingRuleResult executeDeleteSamplingRule(DeleteSamplingRuleRequest deleteSamplingRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSamplingRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSamplingRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSamplingRuleRequestProtocolMarshaller(protocolFactory).marshall((DeleteSamplingRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSamplingRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSamplingRule");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSamplingRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSamplingRuleResult deleteSamplingRuleResult = (DeleteSamplingRuleResult)response.getAwsResponse();
            return deleteSamplingRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEncryptionConfigResult getEncryptionConfig(GetEncryptionConfigRequest request) {
        request = (GetEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executeGetEncryptionConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEncryptionConfigResult executeGetEncryptionConfig(GetEncryptionConfigRequest getEncryptionConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEncryptionConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEncryptionConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEncryptionConfigRequestProtocolMarshaller(protocolFactory).marshall((GetEncryptionConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEncryptionConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEncryptionConfig");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEncryptionConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEncryptionConfigResult getEncryptionConfigResult = (GetEncryptionConfigResult)response.getAwsResponse();
            return getEncryptionConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSamplingRulesResult getSamplingRules(GetSamplingRulesRequest request) {
        request = (GetSamplingRulesRequest)this.beforeClientExecution(request);
        return this.executeGetSamplingRules(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSamplingRulesResult executeGetSamplingRules(GetSamplingRulesRequest getSamplingRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSamplingRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSamplingRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSamplingRulesRequestProtocolMarshaller(protocolFactory).marshall((GetSamplingRulesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSamplingRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSamplingRules");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSamplingRulesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSamplingRulesResult getSamplingRulesResult = (GetSamplingRulesResult)response.getAwsResponse();
            return getSamplingRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSamplingStatisticSummariesResult getSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest request) {
        request = (GetSamplingStatisticSummariesRequest)this.beforeClientExecution(request);
        return this.executeGetSamplingStatisticSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSamplingStatisticSummariesResult executeGetSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest getSamplingStatisticSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSamplingStatisticSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSamplingStatisticSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSamplingStatisticSummariesRequestProtocolMarshaller(protocolFactory).marshall((GetSamplingStatisticSummariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSamplingStatisticSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSamplingStatisticSummaries");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSamplingStatisticSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSamplingStatisticSummariesResult getSamplingStatisticSummariesResult = (GetSamplingStatisticSummariesResult)response.getAwsResponse();
            return getSamplingStatisticSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSamplingTargetsResult getSamplingTargets(GetSamplingTargetsRequest request) {
        request = (GetSamplingTargetsRequest)this.beforeClientExecution(request);
        return this.executeGetSamplingTargets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSamplingTargetsResult executeGetSamplingTargets(GetSamplingTargetsRequest getSamplingTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSamplingTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSamplingTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSamplingTargetsRequestProtocolMarshaller(protocolFactory).marshall((GetSamplingTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSamplingTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSamplingTargets");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSamplingTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSamplingTargetsResult getSamplingTargetsResult = (GetSamplingTargetsResult)response.getAwsResponse();
            return getSamplingTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetServiceGraphResult getServiceGraph(GetServiceGraphRequest request) {
        request = (GetServiceGraphRequest)this.beforeClientExecution(request);
        return this.executeGetServiceGraph(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetServiceGraphResult executeGetServiceGraph(GetServiceGraphRequest getServiceGraphRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getServiceGraphRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetServiceGraphRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetServiceGraphRequestProtocolMarshaller(protocolFactory).marshall((GetServiceGraphRequest)super.beforeMarshalling((AmazonWebServiceRequest)getServiceGraphRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetServiceGraph");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServiceGraphResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetServiceGraphResult getServiceGraphResult = (GetServiceGraphResult)response.getAwsResponse();
            return getServiceGraphResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTraceGraphResult getTraceGraph(GetTraceGraphRequest request) {
        request = (GetTraceGraphRequest)this.beforeClientExecution(request);
        return this.executeGetTraceGraph(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTraceGraphResult executeGetTraceGraph(GetTraceGraphRequest getTraceGraphRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTraceGraphRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTraceGraphRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTraceGraphRequestProtocolMarshaller(protocolFactory).marshall((GetTraceGraphRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTraceGraphRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTraceGraph");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTraceGraphResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTraceGraphResult getTraceGraphResult = (GetTraceGraphResult)response.getAwsResponse();
            return getTraceGraphResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTraceSummariesResult getTraceSummaries(GetTraceSummariesRequest request) {
        request = (GetTraceSummariesRequest)this.beforeClientExecution(request);
        return this.executeGetTraceSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTraceSummariesResult executeGetTraceSummaries(GetTraceSummariesRequest getTraceSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTraceSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTraceSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTraceSummariesRequestProtocolMarshaller(protocolFactory).marshall((GetTraceSummariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTraceSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTraceSummaries");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTraceSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTraceSummariesResult getTraceSummariesResult = (GetTraceSummariesResult)response.getAwsResponse();
            return getTraceSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutEncryptionConfigResult putEncryptionConfig(PutEncryptionConfigRequest request) {
        request = (PutEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executePutEncryptionConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutEncryptionConfigResult executePutEncryptionConfig(PutEncryptionConfigRequest putEncryptionConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEncryptionConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEncryptionConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEncryptionConfigRequestProtocolMarshaller(protocolFactory).marshall((PutEncryptionConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)putEncryptionConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutEncryptionConfig");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutEncryptionConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutEncryptionConfigResult putEncryptionConfigResult = (PutEncryptionConfigResult)response.getAwsResponse();
            return putEncryptionConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutTelemetryRecordsResult putTelemetryRecords(PutTelemetryRecordsRequest request) {
        request = (PutTelemetryRecordsRequest)this.beforeClientExecution(request);
        return this.executePutTelemetryRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutTelemetryRecordsResult executePutTelemetryRecords(PutTelemetryRecordsRequest putTelemetryRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putTelemetryRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutTelemetryRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutTelemetryRecordsRequestProtocolMarshaller(protocolFactory).marshall((PutTelemetryRecordsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putTelemetryRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutTelemetryRecords");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTelemetryRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutTelemetryRecordsResult putTelemetryRecordsResult = (PutTelemetryRecordsResult)response.getAwsResponse();
            return putTelemetryRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutTraceSegmentsResult putTraceSegments(PutTraceSegmentsRequest request) {
        request = (PutTraceSegmentsRequest)this.beforeClientExecution(request);
        return this.executePutTraceSegments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutTraceSegmentsResult executePutTraceSegments(PutTraceSegmentsRequest putTraceSegmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putTraceSegmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutTraceSegmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutTraceSegmentsRequestProtocolMarshaller(protocolFactory).marshall((PutTraceSegmentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putTraceSegmentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutTraceSegments");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTraceSegmentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutTraceSegmentsResult putTraceSegmentsResult = (PutTraceSegmentsResult)response.getAwsResponse();
            return putTraceSegmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSamplingRuleResult updateSamplingRule(UpdateSamplingRuleRequest request) {
        request = (UpdateSamplingRuleRequest)this.beforeClientExecution(request);
        return this.executeUpdateSamplingRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSamplingRuleResult executeUpdateSamplingRule(UpdateSamplingRuleRequest updateSamplingRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSamplingRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSamplingRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSamplingRuleRequestProtocolMarshaller(protocolFactory).marshall((UpdateSamplingRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSamplingRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"XRay");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSamplingRule");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSamplingRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSamplingRuleResult updateSamplingRuleResult = (UpdateSamplingRuleResult)response.getAwsResponse();
            return updateSamplingRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

