/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspacesweb;

import javax.annotation.Generated;

import com.amazonaws.services.workspacesweb.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonWorkSpacesWeb}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonWorkSpacesWeb implements AmazonWorkSpacesWeb {

    protected AbstractAmazonWorkSpacesWeb() {
    }

    @Override
    public AssociateBrowserSettingsResult associateBrowserSettings(AssociateBrowserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateIpAccessSettingsResult associateIpAccessSettings(AssociateIpAccessSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateNetworkSettingsResult associateNetworkSettings(AssociateNetworkSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateTrustStoreResult associateTrustStore(AssociateTrustStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateUserAccessLoggingSettingsResult associateUserAccessLoggingSettings(AssociateUserAccessLoggingSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateUserSettingsResult associateUserSettings(AssociateUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBrowserSettingsResult createBrowserSettings(CreateBrowserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIdentityProviderResult createIdentityProvider(CreateIdentityProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIpAccessSettingsResult createIpAccessSettings(CreateIpAccessSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNetworkSettingsResult createNetworkSettings(CreateNetworkSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePortalResult createPortal(CreatePortalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrustStoreResult createTrustStore(CreateTrustStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserAccessLoggingSettingsResult createUserAccessLoggingSettings(CreateUserAccessLoggingSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserSettingsResult createUserSettings(CreateUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBrowserSettingsResult deleteBrowserSettings(DeleteBrowserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIdentityProviderResult deleteIdentityProvider(DeleteIdentityProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIpAccessSettingsResult deleteIpAccessSettings(DeleteIpAccessSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNetworkSettingsResult deleteNetworkSettings(DeleteNetworkSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePortalResult deletePortal(DeletePortalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrustStoreResult deleteTrustStore(DeleteTrustStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserAccessLoggingSettingsResult deleteUserAccessLoggingSettings(DeleteUserAccessLoggingSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserSettingsResult deleteUserSettings(DeleteUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateBrowserSettingsResult disassociateBrowserSettings(DisassociateBrowserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateIpAccessSettingsResult disassociateIpAccessSettings(DisassociateIpAccessSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateNetworkSettingsResult disassociateNetworkSettings(DisassociateNetworkSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateTrustStoreResult disassociateTrustStore(DisassociateTrustStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateUserAccessLoggingSettingsResult disassociateUserAccessLoggingSettings(DisassociateUserAccessLoggingSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateUserSettingsResult disassociateUserSettings(DisassociateUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBrowserSettingsResult getBrowserSettings(GetBrowserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIdentityProviderResult getIdentityProvider(GetIdentityProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIpAccessSettingsResult getIpAccessSettings(GetIpAccessSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkSettingsResult getNetworkSettings(GetNetworkSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPortalResult getPortal(GetPortalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPortalServiceProviderMetadataResult getPortalServiceProviderMetadata(GetPortalServiceProviderMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTrustStoreResult getTrustStore(GetTrustStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTrustStoreCertificateResult getTrustStoreCertificate(GetTrustStoreCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserAccessLoggingSettingsResult getUserAccessLoggingSettings(GetUserAccessLoggingSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserSettingsResult getUserSettings(GetUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBrowserSettingsResult listBrowserSettings(ListBrowserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIdentityProvidersResult listIdentityProviders(ListIdentityProvidersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIpAccessSettingsResult listIpAccessSettings(ListIpAccessSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNetworkSettingsResult listNetworkSettings(ListNetworkSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPortalsResult listPortals(ListPortalsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrustStoreCertificatesResult listTrustStoreCertificates(ListTrustStoreCertificatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrustStoresResult listTrustStores(ListTrustStoresRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUserAccessLoggingSettingsResult listUserAccessLoggingSettings(ListUserAccessLoggingSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUserSettingsResult listUserSettings(ListUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBrowserSettingsResult updateBrowserSettings(UpdateBrowserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIdentityProviderResult updateIdentityProvider(UpdateIdentityProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIpAccessSettingsResult updateIpAccessSettings(UpdateIpAccessSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNetworkSettingsResult updateNetworkSettings(UpdateNetworkSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePortalResult updatePortal(UpdatePortalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrustStoreResult updateTrustStore(UpdateTrustStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserAccessLoggingSettingsResult updateUserAccessLoggingSettings(UpdateUserAccessLoggingSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserSettingsResult updateUserSettings(UpdateUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
