/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.AccountLink;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListAccountLinksResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<AccountLink> accountLinks;
    private String nextToken;

    public List<AccountLink> getAccountLinks() {
        if (this.accountLinks == null) {
            this.accountLinks = new SdkInternalList();
        }
        return this.accountLinks;
    }

    public void setAccountLinks(Collection<AccountLink> accountLinks) {
        if (accountLinks == null) {
            this.accountLinks = null;
            return;
        }
        this.accountLinks = new SdkInternalList(accountLinks);
    }

    public ListAccountLinksResult withAccountLinks(AccountLink ... accountLinks) {
        if (this.accountLinks == null) {
            this.setAccountLinks((Collection<AccountLink>)new SdkInternalList(accountLinks.length));
        }
        for (AccountLink ele : accountLinks) {
            this.accountLinks.add((Object)ele);
        }
        return this;
    }

    public ListAccountLinksResult withAccountLinks(Collection<AccountLink> accountLinks) {
        this.setAccountLinks(accountLinks);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAccountLinksResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountLinks() != null) {
            sb.append("AccountLinks: ").append(this.getAccountLinks()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountLinksResult)) {
            return false;
        }
        ListAccountLinksResult other = (ListAccountLinksResult)obj;
        if (other.getAccountLinks() == null ^ this.getAccountLinks() == null) {
            return false;
        }
        if (other.getAccountLinks() != null && !other.getAccountLinks().equals(this.getAccountLinks())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountLinks() == null ? 0 : this.getAccountLinks().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAccountLinksResult clone() {
        try {
            return (ListAccountLinksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

