/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.ApplicationSettingsRequest;
import com.amazonaws.services.workspaces.model.Capacity;
import com.amazonaws.services.workspaces.model.Tag;
import com.amazonaws.services.workspaces.model.TimeoutSettings;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateWorkspacesPoolRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String poolName;
    private String description;
    private String bundleId;
    private String directoryId;
    private Capacity capacity;
    private SdkInternalList<Tag> tags;
    private ApplicationSettingsRequest applicationSettings;
    private TimeoutSettings timeoutSettings;

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public CreateWorkspacesPoolRequest withPoolName(String poolName) {
        this.setPoolName(poolName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateWorkspacesPoolRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public CreateWorkspacesPoolRequest withBundleId(String bundleId) {
        this.setBundleId(bundleId);
        return this;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public CreateWorkspacesPoolRequest withDirectoryId(String directoryId) {
        this.setDirectoryId(directoryId);
        return this;
    }

    public void setCapacity(Capacity capacity) {
        this.capacity = capacity;
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    public CreateWorkspacesPoolRequest withCapacity(Capacity capacity) {
        this.setCapacity(capacity);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateWorkspacesPoolRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateWorkspacesPoolRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setApplicationSettings(ApplicationSettingsRequest applicationSettings) {
        this.applicationSettings = applicationSettings;
    }

    public ApplicationSettingsRequest getApplicationSettings() {
        return this.applicationSettings;
    }

    public CreateWorkspacesPoolRequest withApplicationSettings(ApplicationSettingsRequest applicationSettings) {
        this.setApplicationSettings(applicationSettings);
        return this;
    }

    public void setTimeoutSettings(TimeoutSettings timeoutSettings) {
        this.timeoutSettings = timeoutSettings;
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    public CreateWorkspacesPoolRequest withTimeoutSettings(TimeoutSettings timeoutSettings) {
        this.setTimeoutSettings(timeoutSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPoolName() != null) {
            sb.append("PoolName: ").append(this.getPoolName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getBundleId() != null) {
            sb.append("BundleId: ").append(this.getBundleId()).append(",");
        }
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: ").append(this.getDirectoryId()).append(",");
        }
        if (this.getCapacity() != null) {
            sb.append("Capacity: ").append(this.getCapacity()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getApplicationSettings() != null) {
            sb.append("ApplicationSettings: ").append(this.getApplicationSettings()).append(",");
        }
        if (this.getTimeoutSettings() != null) {
            sb.append("TimeoutSettings: ").append(this.getTimeoutSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesPoolRequest)) {
            return false;
        }
        CreateWorkspacesPoolRequest other = (CreateWorkspacesPoolRequest)obj;
        if (other.getPoolName() == null ^ this.getPoolName() == null) {
            return false;
        }
        if (other.getPoolName() != null && !other.getPoolName().equals(this.getPoolName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getBundleId() == null ^ this.getBundleId() == null) {
            return false;
        }
        if (other.getBundleId() != null && !other.getBundleId().equals(this.getBundleId())) {
            return false;
        }
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getCapacity() == null ^ this.getCapacity() == null) {
            return false;
        }
        if (other.getCapacity() != null && !other.getCapacity().equals(this.getCapacity())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getApplicationSettings() == null ^ this.getApplicationSettings() == null) {
            return false;
        }
        if (other.getApplicationSettings() != null && !other.getApplicationSettings().equals(this.getApplicationSettings())) {
            return false;
        }
        if (other.getTimeoutSettings() == null ^ this.getTimeoutSettings() == null) {
            return false;
        }
        return other.getTimeoutSettings() == null || other.getTimeoutSettings().equals(this.getTimeoutSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPoolName() == null ? 0 : this.getPoolName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getBundleId() == null ? 0 : this.getBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getCapacity() == null ? 0 : this.getCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationSettings() == null ? 0 : this.getApplicationSettings().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutSettings() == null ? 0 : this.getTimeoutSettings().hashCode());
        return hashCode;
    }

    public CreateWorkspacesPoolRequest clone() {
        return (CreateWorkspacesPoolRequest)super.clone();
    }
}

