/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspaces.model.Workspace;
import java.util.List;

@SdkInternalApi
public class WorkspaceMarshaller {
    private static final MarshallingInfo<String> WORKSPACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkspaceId").build();
    private static final MarshallingInfo<String> DIRECTORYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryId").build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserName").build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BundleId").build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").build();
    private static final MarshallingInfo<String> COMPUTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputerName").build();
    private static final MarshallingInfo<String> VOLUMEENCRYPTIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeEncryptionKey").build();
    private static final MarshallingInfo<Boolean> USERVOLUMEENCRYPTIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserVolumeEncryptionEnabled").build();
    private static final MarshallingInfo<Boolean> ROOTVOLUMEENCRYPTIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootVolumeEncryptionEnabled").build();
    private static final MarshallingInfo<StructuredPojo> WORKSPACEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkspaceProperties").build();
    private static final MarshallingInfo<List> MODIFICATIONSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModificationStates").build();
    private static final MarshallingInfo<List> RELATEDWORKSPACES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelatedWorkspaces").build();
    private static final WorkspaceMarshaller instance = new WorkspaceMarshaller();

    public static WorkspaceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Workspace workspace, ProtocolMarshaller protocolMarshaller) {
        if (workspace == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)workspace.getWorkspaceId(), WORKSPACEID_BINDING);
            protocolMarshaller.marshall((Object)workspace.getDirectoryId(), DIRECTORYID_BINDING);
            protocolMarshaller.marshall((Object)workspace.getUserName(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)workspace.getIpAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)workspace.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)workspace.getBundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)workspace.getSubnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)workspace.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)workspace.getErrorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)workspace.getComputerName(), COMPUTERNAME_BINDING);
            protocolMarshaller.marshall((Object)workspace.getVolumeEncryptionKey(), VOLUMEENCRYPTIONKEY_BINDING);
            protocolMarshaller.marshall((Object)workspace.getUserVolumeEncryptionEnabled(), USERVOLUMEENCRYPTIONENABLED_BINDING);
            protocolMarshaller.marshall((Object)workspace.getRootVolumeEncryptionEnabled(), ROOTVOLUMEENCRYPTIONENABLED_BINDING);
            protocolMarshaller.marshall((Object)workspace.getWorkspaceProperties(), WORKSPACEPROPERTIES_BINDING);
            protocolMarshaller.marshall(workspace.getModificationStates(), MODIFICATIONSTATES_BINDING);
            protocolMarshaller.marshall(workspace.getRelatedWorkspaces(), RELATEDWORKSPACES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

