/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspaces.model.Tag;
import com.amazonaws.services.workspaces.model.transform.StandbyWorkspaceMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class StandbyWorkspace
implements Serializable,
Cloneable,
StructuredPojo {
    private String primaryWorkspaceId;
    private String volumeEncryptionKey;
    private String directoryId;
    private SdkInternalList<Tag> tags;

    public void setPrimaryWorkspaceId(String primaryWorkspaceId) {
        this.primaryWorkspaceId = primaryWorkspaceId;
    }

    public String getPrimaryWorkspaceId() {
        return this.primaryWorkspaceId;
    }

    public StandbyWorkspace withPrimaryWorkspaceId(String primaryWorkspaceId) {
        this.setPrimaryWorkspaceId(primaryWorkspaceId);
        return this;
    }

    public void setVolumeEncryptionKey(String volumeEncryptionKey) {
        this.volumeEncryptionKey = volumeEncryptionKey;
    }

    public String getVolumeEncryptionKey() {
        return this.volumeEncryptionKey;
    }

    public StandbyWorkspace withVolumeEncryptionKey(String volumeEncryptionKey) {
        this.setVolumeEncryptionKey(volumeEncryptionKey);
        return this;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public StandbyWorkspace withDirectoryId(String directoryId) {
        this.setDirectoryId(directoryId);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public StandbyWorkspace withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public StandbyWorkspace withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrimaryWorkspaceId() != null) {
            sb.append("PrimaryWorkspaceId: ").append(this.getPrimaryWorkspaceId()).append(",");
        }
        if (this.getVolumeEncryptionKey() != null) {
            sb.append("VolumeEncryptionKey: ").append(this.getVolumeEncryptionKey()).append(",");
        }
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: ").append(this.getDirectoryId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandbyWorkspace)) {
            return false;
        }
        StandbyWorkspace other = (StandbyWorkspace)obj;
        if (other.getPrimaryWorkspaceId() == null ^ this.getPrimaryWorkspaceId() == null) {
            return false;
        }
        if (other.getPrimaryWorkspaceId() != null && !other.getPrimaryWorkspaceId().equals(this.getPrimaryWorkspaceId())) {
            return false;
        }
        if (other.getVolumeEncryptionKey() == null ^ this.getVolumeEncryptionKey() == null) {
            return false;
        }
        if (other.getVolumeEncryptionKey() != null && !other.getVolumeEncryptionKey().equals(this.getVolumeEncryptionKey())) {
            return false;
        }
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrimaryWorkspaceId() == null ? 0 : this.getPrimaryWorkspaceId().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeEncryptionKey() == null ? 0 : this.getVolumeEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StandbyWorkspace clone() {
        try {
            return (StandbyWorkspace)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StandbyWorkspaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

