/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspaces.model.WorkspaceBundle;
import java.util.Date;

@SdkInternalApi
public class WorkspaceBundleMarshaller {
    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BundleId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> IMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageId").build();
    private static final MarshallingInfo<StructuredPojo> ROOTSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootStorage").build();
    private static final MarshallingInfo<StructuredPojo> USERSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserStorage").build();
    private static final MarshallingInfo<StructuredPojo> COMPUTETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeType").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final WorkspaceBundleMarshaller instance = new WorkspaceBundleMarshaller();

    public static WorkspaceBundleMarshaller getInstance() {
        return instance;
    }

    public void marshall(WorkspaceBundle workspaceBundle, ProtocolMarshaller protocolMarshaller) {
        if (workspaceBundle == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)workspaceBundle.getBundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)workspaceBundle.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)workspaceBundle.getOwner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)workspaceBundle.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)workspaceBundle.getImageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall((Object)workspaceBundle.getRootStorage(), ROOTSTORAGE_BINDING);
            protocolMarshaller.marshall((Object)workspaceBundle.getUserStorage(), USERSTORAGE_BINDING);
            protocolMarshaller.marshall((Object)workspaceBundle.getComputeType(), COMPUTETYPE_BINDING);
            protocolMarshaller.marshall((Object)workspaceBundle.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)workspaceBundle.getCreationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

