/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspaces.model.WorkspaceImage;
import java.util.Date;

@SdkInternalApi
public class WorkspaceImageMarshaller {
    private static final MarshallingInfo<String> IMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<StructuredPojo> OPERATINGSYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperatingSystem").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> REQUIREDTENANCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequiredTenancy").build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<Date> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Created").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> OWNERACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerAccountId").build();
    private static final WorkspaceImageMarshaller instance = new WorkspaceImageMarshaller();

    public static WorkspaceImageMarshaller getInstance() {
        return instance;
    }

    public void marshall(WorkspaceImage workspaceImage, ProtocolMarshaller protocolMarshaller) {
        if (workspaceImage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)workspaceImage.getImageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall((Object)workspaceImage.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)workspaceImage.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)workspaceImage.getOperatingSystem(), OPERATINGSYSTEM_BINDING);
            protocolMarshaller.marshall((Object)workspaceImage.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)workspaceImage.getRequiredTenancy(), REQUIREDTENANCY_BINDING);
            protocolMarshaller.marshall((Object)workspaceImage.getErrorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)workspaceImage.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)workspaceImage.getCreated(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)workspaceImage.getOwnerAccountId(), OWNERACCOUNTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

