/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.TerminateRequest;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.transform.TerminateRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class TerminateWorkspacesRequestMarshaller
implements Marshaller<Request<TerminateWorkspacesRequest>, TerminateWorkspacesRequest> {
    public Request<TerminateWorkspacesRequest> marshall(TerminateWorkspacesRequest terminateWorkspacesRequest) {
        if (terminateWorkspacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)terminateWorkspacesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.TerminateWorkspaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            SdkInternalList terminateWorkspaceRequestsList = (SdkInternalList)terminateWorkspacesRequest.getTerminateWorkspaceRequests();
            if (!terminateWorkspaceRequestsList.isEmpty() || !terminateWorkspaceRequestsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TerminateWorkspaceRequests");
                jsonGenerator.writeStartArray();
                for (TerminateRequest terminateWorkspaceRequestsListValue : terminateWorkspaceRequestsList) {
                    if (terminateWorkspaceRequestsListValue == null) continue;
                    TerminateRequestJsonMarshaller.getInstance().marshall(terminateWorkspaceRequestsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

