/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeWorkspacesRequestMarshaller
implements Marshaller<Request<DescribeWorkspacesRequest>, DescribeWorkspacesRequest> {
    public Request<DescribeWorkspacesRequest> marshall(DescribeWorkspacesRequest describeWorkspacesRequest) {
        if (describeWorkspacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeWorkspacesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.DescribeWorkspaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            SdkInternalList workspaceIdsList = (SdkInternalList)describeWorkspacesRequest.getWorkspaceIds();
            if (!workspaceIdsList.isEmpty() || !workspaceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("WorkspaceIds");
                jsonGenerator.writeStartArray();
                for (String workspaceIdsListValue : workspaceIdsList) {
                    if (workspaceIdsListValue == null) continue;
                    jsonGenerator.writeValue(workspaceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeWorkspacesRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(describeWorkspacesRequest.getDirectoryId());
            }
            if (describeWorkspacesRequest.getUserName() != null) {
                jsonGenerator.writeFieldName("UserName").writeValue(describeWorkspacesRequest.getUserName());
            }
            if (describeWorkspacesRequest.getBundleId() != null) {
                jsonGenerator.writeFieldName("BundleId").writeValue(describeWorkspacesRequest.getBundleId());
            }
            if (describeWorkspacesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeWorkspacesRequest.getLimit().intValue());
            }
            if (describeWorkspacesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeWorkspacesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

