/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.workspaces.model.WorkspaceBundle;
import com.amazonaws.services.workspaces.model.transform.ComputeTypeJsonMarshaller;
import com.amazonaws.services.workspaces.model.transform.UserStorageJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class WorkspaceBundleJsonMarshaller {
    private static WorkspaceBundleJsonMarshaller instance;

    public void marshall(WorkspaceBundle workspaceBundle, JSONWriter jsonWriter) {
        if (workspaceBundle == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (workspaceBundle.getBundleId() != null) {
                jsonWriter.key("BundleId").value((Object)workspaceBundle.getBundleId());
            }
            if (workspaceBundle.getName() != null) {
                jsonWriter.key("Name").value((Object)workspaceBundle.getName());
            }
            if (workspaceBundle.getOwner() != null) {
                jsonWriter.key("Owner").value((Object)workspaceBundle.getOwner());
            }
            if (workspaceBundle.getDescription() != null) {
                jsonWriter.key("Description").value((Object)workspaceBundle.getDescription());
            }
            if (workspaceBundle.getUserStorage() != null) {
                jsonWriter.key("UserStorage");
                UserStorageJsonMarshaller.getInstance().marshall(workspaceBundle.getUserStorage(), jsonWriter);
            }
            if (workspaceBundle.getComputeType() != null) {
                jsonWriter.key("ComputeType");
                ComputeTypeJsonMarshaller.getInstance().marshall(workspaceBundle.getComputeType(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkspaceBundleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkspaceBundleJsonMarshaller();
        }
        return instance;
    }
}

