/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.workspaces.AmazonWorkspacesAsync;
import com.amazonaws.services.workspaces.AmazonWorkspacesClient;
import com.amazonaws.services.workspaces.model.CreateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.CreateWorkspacesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesResult;
import com.amazonaws.services.workspaces.model.RebootWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebootWorkspacesResult;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesResult;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonWorkspacesAsyncClient
extends AmazonWorkspacesClient
implements AmazonWorkspacesAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonWorkspacesAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonWorkspacesAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonWorkspacesAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonWorkspacesAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonWorkspacesAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateWorkspacesResult> createWorkspacesAsync(CreateWorkspacesRequest request) {
        return this.createWorkspacesAsync(request, null);
    }

    @Override
    public Future<CreateWorkspacesResult> createWorkspacesAsync(final CreateWorkspacesRequest request, final AsyncHandler<CreateWorkspacesRequest, CreateWorkspacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateWorkspacesResult>(){

            @Override
            public CreateWorkspacesResult call() throws Exception {
                CreateWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.createWorkspaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync(DescribeWorkspaceBundlesRequest request) {
        return this.describeWorkspaceBundlesAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync(final DescribeWorkspaceBundlesRequest request, final AsyncHandler<DescribeWorkspaceBundlesRequest, DescribeWorkspaceBundlesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeWorkspaceBundlesResult>(){

            @Override
            public DescribeWorkspaceBundlesResult call() throws Exception {
                DescribeWorkspaceBundlesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.describeWorkspaceBundles(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync() {
        return this.describeWorkspaceBundlesAsync(new DescribeWorkspaceBundlesRequest());
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync(AsyncHandler<DescribeWorkspaceBundlesRequest, DescribeWorkspaceBundlesResult> asyncHandler) {
        return this.describeWorkspaceBundlesAsync(new DescribeWorkspaceBundlesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync(DescribeWorkspaceDirectoriesRequest request) {
        return this.describeWorkspaceDirectoriesAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync(final DescribeWorkspaceDirectoriesRequest request, final AsyncHandler<DescribeWorkspaceDirectoriesRequest, DescribeWorkspaceDirectoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeWorkspaceDirectoriesResult>(){

            @Override
            public DescribeWorkspaceDirectoriesResult call() throws Exception {
                DescribeWorkspaceDirectoriesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.describeWorkspaceDirectories(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync() {
        return this.describeWorkspaceDirectoriesAsync(new DescribeWorkspaceDirectoriesRequest());
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync(AsyncHandler<DescribeWorkspaceDirectoriesRequest, DescribeWorkspaceDirectoriesResult> asyncHandler) {
        return this.describeWorkspaceDirectoriesAsync(new DescribeWorkspaceDirectoriesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync(DescribeWorkspacesRequest request) {
        return this.describeWorkspacesAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync(final DescribeWorkspacesRequest request, final AsyncHandler<DescribeWorkspacesRequest, DescribeWorkspacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeWorkspacesResult>(){

            @Override
            public DescribeWorkspacesResult call() throws Exception {
                DescribeWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.describeWorkspaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync() {
        return this.describeWorkspacesAsync(new DescribeWorkspacesRequest());
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync(AsyncHandler<DescribeWorkspacesRequest, DescribeWorkspacesResult> asyncHandler) {
        return this.describeWorkspacesAsync(new DescribeWorkspacesRequest(), asyncHandler);
    }

    @Override
    public Future<RebootWorkspacesResult> rebootWorkspacesAsync(RebootWorkspacesRequest request) {
        return this.rebootWorkspacesAsync(request, null);
    }

    @Override
    public Future<RebootWorkspacesResult> rebootWorkspacesAsync(final RebootWorkspacesRequest request, final AsyncHandler<RebootWorkspacesRequest, RebootWorkspacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<RebootWorkspacesResult>(){

            @Override
            public RebootWorkspacesResult call() throws Exception {
                RebootWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.rebootWorkspaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RebuildWorkspacesResult> rebuildWorkspacesAsync(RebuildWorkspacesRequest request) {
        return this.rebuildWorkspacesAsync(request, null);
    }

    @Override
    public Future<RebuildWorkspacesResult> rebuildWorkspacesAsync(final RebuildWorkspacesRequest request, final AsyncHandler<RebuildWorkspacesRequest, RebuildWorkspacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<RebuildWorkspacesResult>(){

            @Override
            public RebuildWorkspacesResult call() throws Exception {
                RebuildWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.rebuildWorkspaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TerminateWorkspacesResult> terminateWorkspacesAsync(TerminateWorkspacesRequest request) {
        return this.terminateWorkspacesAsync(request, null);
    }

    @Override
    public Future<TerminateWorkspacesResult> terminateWorkspacesAsync(final TerminateWorkspacesRequest request, final AsyncHandler<TerminateWorkspacesRequest, TerminateWorkspacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<TerminateWorkspacesResult>(){

            @Override
            public TerminateWorkspacesResult call() throws Exception {
                TerminateWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.terminateWorkspaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

