/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class DescribeWorkspacesRequestMarshaller
implements Marshaller<Request<DescribeWorkspacesRequest>, DescribeWorkspacesRequest> {
    public Request<DescribeWorkspacesRequest> marshall(DescribeWorkspacesRequest describeWorkspacesRequest) {
        if (describeWorkspacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeWorkspacesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.DescribeWorkspaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            SdkInternalList workspaceIdsList = (SdkInternalList)describeWorkspacesRequest.getWorkspaceIds();
            if (!workspaceIdsList.isEmpty() || !workspaceIdsList.isAutoConstruct()) {
                jsonWriter.key("WorkspaceIds");
                jsonWriter.array();
                for (String workspaceIdsListValue : workspaceIdsList) {
                    if (workspaceIdsListValue == null) continue;
                    jsonWriter.value((Object)workspaceIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeWorkspacesRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value((Object)describeWorkspacesRequest.getDirectoryId());
            }
            if (describeWorkspacesRequest.getUserName() != null) {
                jsonWriter.key("UserName").value((Object)describeWorkspacesRequest.getUserName());
            }
            if (describeWorkspacesRequest.getBundleId() != null) {
                jsonWriter.key("BundleId").value((Object)describeWorkspacesRequest.getBundleId());
            }
            if (describeWorkspacesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value((Object)describeWorkspacesRequest.getLimit());
            }
            if (describeWorkspacesRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value((Object)describeWorkspacesRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

