/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.workspaces.model.Workspace;
import com.amazonaws.util.json.JSONWriter;

public class WorkspaceJsonMarshaller {
    private static WorkspaceJsonMarshaller instance;

    public void marshall(Workspace workspace, JSONWriter jsonWriter) {
        if (workspace == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (workspace.getWorkspaceId() != null) {
                jsonWriter.key("WorkspaceId").value((Object)workspace.getWorkspaceId());
            }
            if (workspace.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value((Object)workspace.getDirectoryId());
            }
            if (workspace.getUserName() != null) {
                jsonWriter.key("UserName").value((Object)workspace.getUserName());
            }
            if (workspace.getIpAddress() != null) {
                jsonWriter.key("IpAddress").value((Object)workspace.getIpAddress());
            }
            if (workspace.getState() != null) {
                jsonWriter.key("State").value((Object)workspace.getState());
            }
            if (workspace.getBundleId() != null) {
                jsonWriter.key("BundleId").value((Object)workspace.getBundleId());
            }
            if (workspace.getSubnetId() != null) {
                jsonWriter.key("SubnetId").value((Object)workspace.getSubnetId());
            }
            if (workspace.getErrorMessage() != null) {
                jsonWriter.key("ErrorMessage").value((Object)workspace.getErrorMessage());
            }
            if (workspace.getErrorCode() != null) {
                jsonWriter.key("ErrorCode").value((Object)workspace.getErrorCode());
            }
            if (workspace.getComputerName() != null) {
                jsonWriter.key("ComputerName").value((Object)workspace.getComputerName());
            }
            if (workspace.getVolumeEncryptionKey() != null) {
                jsonWriter.key("VolumeEncryptionKey").value((Object)workspace.getVolumeEncryptionKey());
            }
            if (workspace.getUserVolumeEncryptionEnabled() != null) {
                jsonWriter.key("UserVolumeEncryptionEnabled").value((Object)workspace.getUserVolumeEncryptionEnabled());
            }
            if (workspace.getRootVolumeEncryptionEnabled() != null) {
                jsonWriter.key("RootVolumeEncryptionEnabled").value((Object)workspace.getRootVolumeEncryptionEnabled());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkspaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkspaceJsonMarshaller();
        }
        return instance;
    }
}

