/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.workmail.model.ImpersonationRoleType;
import com.amazonaws.services.workmail.model.ImpersonationRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateImpersonationRoleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String organizationId;
    private String name;
    private String type;
    private String description;
    private List<ImpersonationRule> rules;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateImpersonationRoleRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public CreateImpersonationRoleRequest withOrganizationId(String organizationId) {
        this.setOrganizationId(organizationId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateImpersonationRoleRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateImpersonationRoleRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateImpersonationRoleRequest withType(ImpersonationRoleType type) {
        this.type = type.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateImpersonationRoleRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<ImpersonationRule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<ImpersonationRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<ImpersonationRule>(rules);
    }

    public CreateImpersonationRoleRequest withRules(ImpersonationRule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<ImpersonationRule>(rules.length));
        }
        for (ImpersonationRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public CreateImpersonationRoleRequest withRules(Collection<ImpersonationRule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getOrganizationId() != null) {
            sb.append("OrganizationId: ").append(this.getOrganizationId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImpersonationRoleRequest)) {
            return false;
        }
        CreateImpersonationRoleRequest other = (CreateImpersonationRoleRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getOrganizationId() == null ^ this.getOrganizationId() == null) {
            return false;
        }
        if (other.getOrganizationId() != null && !other.getOrganizationId().equals(this.getOrganizationId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationId() == null ? 0 : this.getOrganizationId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public CreateImpersonationRoleRequest clone() {
        return (CreateImpersonationRoleRequest)super.clone();
    }
}

