/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.workdocs.model.AdditionalResponseFieldType;
import com.amazonaws.services.workdocs.model.Filters;
import com.amazonaws.services.workdocs.model.SearchQueryScopeType;
import com.amazonaws.services.workdocs.model.SearchSortResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String authenticationToken;
    private String queryText;
    private List<String> queryScopes;
    private String organizationId;
    private List<String> additionalResponseFields;
    private Filters filters;
    private List<SearchSortResult> orderBy;
    private Integer limit;
    private String marker;

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public SearchResourcesRequest withAuthenticationToken(String authenticationToken) {
        this.setAuthenticationToken(authenticationToken);
        return this;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public SearchResourcesRequest withQueryText(String queryText) {
        this.setQueryText(queryText);
        return this;
    }

    public List<String> getQueryScopes() {
        return this.queryScopes;
    }

    public void setQueryScopes(Collection<String> queryScopes) {
        if (queryScopes == null) {
            this.queryScopes = null;
            return;
        }
        this.queryScopes = new ArrayList<String>(queryScopes);
    }

    public SearchResourcesRequest withQueryScopes(String ... queryScopes) {
        if (this.queryScopes == null) {
            this.setQueryScopes(new ArrayList<String>(queryScopes.length));
        }
        for (String ele : queryScopes) {
            this.queryScopes.add(ele);
        }
        return this;
    }

    public SearchResourcesRequest withQueryScopes(Collection<String> queryScopes) {
        this.setQueryScopes(queryScopes);
        return this;
    }

    public SearchResourcesRequest withQueryScopes(SearchQueryScopeType ... queryScopes) {
        ArrayList<String> queryScopesCopy = new ArrayList<String>(queryScopes.length);
        for (SearchQueryScopeType value : queryScopes) {
            queryScopesCopy.add(value.toString());
        }
        if (this.getQueryScopes() == null) {
            this.setQueryScopes(queryScopesCopy);
        } else {
            this.getQueryScopes().addAll(queryScopesCopy);
        }
        return this;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public SearchResourcesRequest withOrganizationId(String organizationId) {
        this.setOrganizationId(organizationId);
        return this;
    }

    public List<String> getAdditionalResponseFields() {
        return this.additionalResponseFields;
    }

    public void setAdditionalResponseFields(Collection<String> additionalResponseFields) {
        if (additionalResponseFields == null) {
            this.additionalResponseFields = null;
            return;
        }
        this.additionalResponseFields = new ArrayList<String>(additionalResponseFields);
    }

    public SearchResourcesRequest withAdditionalResponseFields(String ... additionalResponseFields) {
        if (this.additionalResponseFields == null) {
            this.setAdditionalResponseFields(new ArrayList<String>(additionalResponseFields.length));
        }
        for (String ele : additionalResponseFields) {
            this.additionalResponseFields.add(ele);
        }
        return this;
    }

    public SearchResourcesRequest withAdditionalResponseFields(Collection<String> additionalResponseFields) {
        this.setAdditionalResponseFields(additionalResponseFields);
        return this;
    }

    public SearchResourcesRequest withAdditionalResponseFields(AdditionalResponseFieldType ... additionalResponseFields) {
        ArrayList<String> additionalResponseFieldsCopy = new ArrayList<String>(additionalResponseFields.length);
        for (AdditionalResponseFieldType value : additionalResponseFields) {
            additionalResponseFieldsCopy.add(value.toString());
        }
        if (this.getAdditionalResponseFields() == null) {
            this.setAdditionalResponseFields(additionalResponseFieldsCopy);
        } else {
            this.getAdditionalResponseFields().addAll(additionalResponseFieldsCopy);
        }
        return this;
    }

    public void setFilters(Filters filters) {
        this.filters = filters;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public SearchResourcesRequest withFilters(Filters filters) {
        this.setFilters(filters);
        return this;
    }

    public List<SearchSortResult> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(Collection<SearchSortResult> orderBy) {
        if (orderBy == null) {
            this.orderBy = null;
            return;
        }
        this.orderBy = new ArrayList<SearchSortResult>(orderBy);
    }

    public SearchResourcesRequest withOrderBy(SearchSortResult ... orderBy) {
        if (this.orderBy == null) {
            this.setOrderBy(new ArrayList<SearchSortResult>(orderBy.length));
        }
        for (SearchSortResult ele : orderBy) {
            this.orderBy.add(ele);
        }
        return this;
    }

    public SearchResourcesRequest withOrderBy(Collection<SearchSortResult> orderBy) {
        this.setOrderBy(orderBy);
        return this;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SearchResourcesRequest withLimit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public SearchResourcesRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthenticationToken() != null) {
            sb.append("AuthenticationToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getQueryText() != null) {
            sb.append("QueryText: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getQueryScopes() != null) {
            sb.append("QueryScopes: ").append(this.getQueryScopes()).append(",");
        }
        if (this.getOrganizationId() != null) {
            sb.append("OrganizationId: ").append(this.getOrganizationId()).append(",");
        }
        if (this.getAdditionalResponseFields() != null) {
            sb.append("AdditionalResponseFields: ").append(this.getAdditionalResponseFields()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getOrderBy() != null) {
            sb.append("OrderBy: ").append(this.getOrderBy()).append(",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: ").append(this.getLimit()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesRequest)) {
            return false;
        }
        SearchResourcesRequest other = (SearchResourcesRequest)obj;
        if (other.getAuthenticationToken() == null ^ this.getAuthenticationToken() == null) {
            return false;
        }
        if (other.getAuthenticationToken() != null && !other.getAuthenticationToken().equals(this.getAuthenticationToken())) {
            return false;
        }
        if (other.getQueryText() == null ^ this.getQueryText() == null) {
            return false;
        }
        if (other.getQueryText() != null && !other.getQueryText().equals(this.getQueryText())) {
            return false;
        }
        if (other.getQueryScopes() == null ^ this.getQueryScopes() == null) {
            return false;
        }
        if (other.getQueryScopes() != null && !other.getQueryScopes().equals(this.getQueryScopes())) {
            return false;
        }
        if (other.getOrganizationId() == null ^ this.getOrganizationId() == null) {
            return false;
        }
        if (other.getOrganizationId() != null && !other.getOrganizationId().equals(this.getOrganizationId())) {
            return false;
        }
        if (other.getAdditionalResponseFields() == null ^ this.getAdditionalResponseFields() == null) {
            return false;
        }
        if (other.getAdditionalResponseFields() != null && !other.getAdditionalResponseFields().equals(this.getAdditionalResponseFields())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getOrderBy() == null ^ this.getOrderBy() == null) {
            return false;
        }
        if (other.getOrderBy() != null && !other.getOrderBy().equals(this.getOrderBy())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthenticationToken() == null ? 0 : this.getAuthenticationToken().hashCode());
        hashCode = 31 * hashCode + (this.getQueryText() == null ? 0 : this.getQueryText().hashCode());
        hashCode = 31 * hashCode + (this.getQueryScopes() == null ? 0 : this.getQueryScopes().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationId() == null ? 0 : this.getOrganizationId().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalResponseFields() == null ? 0 : this.getAdditionalResponseFields().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getOrderBy() == null ? 0 : this.getOrderBy().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public SearchResourcesRequest clone() {
        return (SearchResourcesRequest)super.clone();
    }
}

