/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wellarchitected.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.wellarchitected.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ShareInvitationSummary JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ShareInvitationSummaryJsonUnmarshaller implements Unmarshaller<ShareInvitationSummary, JsonUnmarshallerContext> {

    public ShareInvitationSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        ShareInvitationSummary shareInvitationSummary = new ShareInvitationSummary();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ShareInvitationId", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setShareInvitationId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SharedBy", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setSharedBy(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SharedWith", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setSharedWith(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PermissionType", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setPermissionType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ShareResourceType", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setShareResourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WorkloadName", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setWorkloadName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WorkloadId", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setWorkloadId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LensName", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setLensName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LensArn", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setLensArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ProfileName", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setProfileName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ProfileArn", targetDepth)) {
                    context.nextToken();
                    shareInvitationSummary.setProfileArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return shareInvitationSummary;
    }

    private static ShareInvitationSummaryJsonUnmarshaller instance;

    public static ShareInvitationSummaryJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new ShareInvitationSummaryJsonUnmarshaller();
        return instance;
    }
}
