/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.vpclattice.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.vpclattice.model.Target;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RegisterTargetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String targetGroupIdentifier;
    private List<Target> targets;

    public void setTargetGroupIdentifier(String targetGroupIdentifier) {
        this.targetGroupIdentifier = targetGroupIdentifier;
    }

    public String getTargetGroupIdentifier() {
        return this.targetGroupIdentifier;
    }

    public RegisterTargetsRequest withTargetGroupIdentifier(String targetGroupIdentifier) {
        this.setTargetGroupIdentifier(targetGroupIdentifier);
        return this;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<Target>(targets);
    }

    public RegisterTargetsRequest withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<Target>(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public RegisterTargetsRequest withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetGroupIdentifier() != null) {
            sb.append("TargetGroupIdentifier: ").append(this.getTargetGroupIdentifier()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetsRequest)) {
            return false;
        }
        RegisterTargetsRequest other = (RegisterTargetsRequest)obj;
        if (other.getTargetGroupIdentifier() == null ^ this.getTargetGroupIdentifier() == null) {
            return false;
        }
        if (other.getTargetGroupIdentifier() != null && !other.getTargetGroupIdentifier().equals(this.getTargetGroupIdentifier())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        return other.getTargets() == null || other.getTargets().equals(this.getTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetGroupIdentifier() == null ? 0 : this.getTargetGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        return hashCode;
    }

    public RegisterTargetsRequest clone() {
        return (RegisterTargetsRequest)super.clone();
    }
}

