/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.verifiedpermissions.model.OpenIdConnectGroupConfiguration;
import com.amazonaws.services.verifiedpermissions.model.OpenIdConnectTokenSelection;
import com.amazonaws.services.verifiedpermissions.model.transform.OpenIdConnectConfigurationMarshaller;
import java.io.Serializable;

public class OpenIdConnectConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String issuer;
    private String entityIdPrefix;
    private OpenIdConnectGroupConfiguration groupConfiguration;
    private OpenIdConnectTokenSelection tokenSelection;

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public OpenIdConnectConfiguration withIssuer(String issuer) {
        this.setIssuer(issuer);
        return this;
    }

    public void setEntityIdPrefix(String entityIdPrefix) {
        this.entityIdPrefix = entityIdPrefix;
    }

    public String getEntityIdPrefix() {
        return this.entityIdPrefix;
    }

    public OpenIdConnectConfiguration withEntityIdPrefix(String entityIdPrefix) {
        this.setEntityIdPrefix(entityIdPrefix);
        return this;
    }

    public void setGroupConfiguration(OpenIdConnectGroupConfiguration groupConfiguration) {
        this.groupConfiguration = groupConfiguration;
    }

    public OpenIdConnectGroupConfiguration getGroupConfiguration() {
        return this.groupConfiguration;
    }

    public OpenIdConnectConfiguration withGroupConfiguration(OpenIdConnectGroupConfiguration groupConfiguration) {
        this.setGroupConfiguration(groupConfiguration);
        return this;
    }

    public void setTokenSelection(OpenIdConnectTokenSelection tokenSelection) {
        this.tokenSelection = tokenSelection;
    }

    public OpenIdConnectTokenSelection getTokenSelection() {
        return this.tokenSelection;
    }

    public OpenIdConnectConfiguration withTokenSelection(OpenIdConnectTokenSelection tokenSelection) {
        this.setTokenSelection(tokenSelection);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIssuer() != null) {
            sb.append("Issuer: ").append(this.getIssuer()).append(",");
        }
        if (this.getEntityIdPrefix() != null) {
            sb.append("EntityIdPrefix: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getGroupConfiguration() != null) {
            sb.append("GroupConfiguration: ").append(this.getGroupConfiguration()).append(",");
        }
        if (this.getTokenSelection() != null) {
            sb.append("TokenSelection: ").append(this.getTokenSelection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIdConnectConfiguration)) {
            return false;
        }
        OpenIdConnectConfiguration other = (OpenIdConnectConfiguration)obj;
        if (other.getIssuer() == null ^ this.getIssuer() == null) {
            return false;
        }
        if (other.getIssuer() != null && !other.getIssuer().equals(this.getIssuer())) {
            return false;
        }
        if (other.getEntityIdPrefix() == null ^ this.getEntityIdPrefix() == null) {
            return false;
        }
        if (other.getEntityIdPrefix() != null && !other.getEntityIdPrefix().equals(this.getEntityIdPrefix())) {
            return false;
        }
        if (other.getGroupConfiguration() == null ^ this.getGroupConfiguration() == null) {
            return false;
        }
        if (other.getGroupConfiguration() != null && !other.getGroupConfiguration().equals(this.getGroupConfiguration())) {
            return false;
        }
        if (other.getTokenSelection() == null ^ this.getTokenSelection() == null) {
            return false;
        }
        return other.getTokenSelection() == null || other.getTokenSelection().equals(this.getTokenSelection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIssuer() == null ? 0 : this.getIssuer().hashCode());
        hashCode = 31 * hashCode + (this.getEntityIdPrefix() == null ? 0 : this.getEntityIdPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getGroupConfiguration() == null ? 0 : this.getGroupConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTokenSelection() == null ? 0 : this.getTokenSelection().hashCode());
        return hashCode;
    }

    public OpenIdConnectConfiguration clone() {
        try {
            return (OpenIdConnectConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpenIdConnectConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

