/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.verifiedpermissions.model.PolicyItem;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class PolicyItemMarshaller {
    private static final MarshallingInfo<String> POLICYSTOREID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyStoreId").build();
    private static final MarshallingInfo<String> POLICYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyId").build();
    private static final MarshallingInfo<String> POLICYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyType").build();
    private static final MarshallingInfo<StructuredPojo> PRINCIPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("principal").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resource").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").build();
    private static final MarshallingInfo<StructuredPojo> DEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("definition").build();
    private static final MarshallingInfo<Date> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> LASTUPDATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDate").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> EFFECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("effect").build();
    private static final PolicyItemMarshaller instance = new PolicyItemMarshaller();

    public static PolicyItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(PolicyItem policyItem, ProtocolMarshaller protocolMarshaller) {
        if (policyItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)policyItem.getPolicyStoreId(), POLICYSTOREID_BINDING);
            protocolMarshaller.marshall((Object)policyItem.getPolicyId(), POLICYID_BINDING);
            protocolMarshaller.marshall((Object)policyItem.getPolicyType(), POLICYTYPE_BINDING);
            protocolMarshaller.marshall((Object)policyItem.getPrincipal(), PRINCIPAL_BINDING);
            protocolMarshaller.marshall((Object)policyItem.getResource(), RESOURCE_BINDING);
            protocolMarshaller.marshall(policyItem.getActions(), ACTIONS_BINDING);
            protocolMarshaller.marshall((Object)policyItem.getDefinition(), DEFINITION_BINDING);
            protocolMarshaller.marshall((Object)policyItem.getCreatedDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)policyItem.getLastUpdatedDate(), LASTUPDATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)policyItem.getEffect(), EFFECT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

