/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.verifiedpermissions.model.AttributeValue;
import com.amazonaws.services.verifiedpermissions.model.EntityIdentifier;
import com.amazonaws.services.verifiedpermissions.model.transform.EntityItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityItem
implements Serializable,
Cloneable,
StructuredPojo {
    private EntityIdentifier identifier;
    private Map<String, AttributeValue> attributes;
    private List<EntityIdentifier> parents;

    public void setIdentifier(EntityIdentifier identifier) {
        this.identifier = identifier;
    }

    public EntityIdentifier getIdentifier() {
        return this.identifier;
    }

    public EntityItem withIdentifier(EntityIdentifier identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public Map<String, AttributeValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, AttributeValue> attributes) {
        this.attributes = attributes;
    }

    public EntityItem withAttributes(Map<String, AttributeValue> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public EntityItem addAttributesEntry(String key, AttributeValue value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, AttributeValue>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public EntityItem clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public List<EntityIdentifier> getParents() {
        return this.parents;
    }

    public void setParents(Collection<EntityIdentifier> parents) {
        if (parents == null) {
            this.parents = null;
            return;
        }
        this.parents = new ArrayList<EntityIdentifier>(parents);
    }

    public EntityItem withParents(EntityIdentifier ... parents) {
        if (this.parents == null) {
            this.setParents(new ArrayList<EntityIdentifier>(parents.length));
        }
        for (EntityIdentifier ele : parents) {
            this.parents.add(ele);
        }
        return this;
    }

    public EntityItem withParents(Collection<EntityIdentifier> parents) {
        this.setParents(parents);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentifier() != null) {
            sb.append("Identifier: ").append(this.getIdentifier()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getParents() != null) {
            sb.append("Parents: ").append(this.getParents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityItem)) {
            return false;
        }
        EntityItem other = (EntityItem)obj;
        if (other.getIdentifier() == null ^ this.getIdentifier() == null) {
            return false;
        }
        if (other.getIdentifier() != null && !other.getIdentifier().equals(this.getIdentifier())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getParents() == null ^ this.getParents() == null) {
            return false;
        }
        return other.getParents() == null || other.getParents().equals(this.getParents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getParents() == null ? 0 : this.getParents().hashCode());
        return hashCode;
    }

    public EntityItem clone() {
        try {
            return (EntityItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

